/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.serializers;

import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.UUIDGen;
import java.nio.ByteBuffer;
import java.util.UUID;

public class UUIDSerializer
implements TypeSerializer<UUID> {
    public static final UUIDSerializer instance = new UUIDSerializer();

    @Override
    public UUID deserialize(ByteBuffer bytes) {
        return bytes.remaining() == 0 ? null : UUIDGen.getUUID(bytes);
    }

    @Override
    public ByteBuffer serialize(UUID value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBuffer.wrap(UUIDGen.decompose(value));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 16 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("UUID should be 16 or 0 bytes (%d)", bytes.remaining()));
        }
    }

    @Override
    public String toString(UUID value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public Class<UUID> getType() {
        return UUID.class;
    }
}

