/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming;

import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Range;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.DefaultConnectionFactory;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamConnectionFactory;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamEventHandler;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamResultFuture;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamSession;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.UUIDGen;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class StreamPlan {
    private final UUID planId = UUIDGen.getTimeUUID();
    private final String description;
    private final List<StreamEventHandler> handlers = new ArrayList<StreamEventHandler>();
    private final Map<InetAddress, StreamSession> sessions = new HashMap<InetAddress, StreamSession>();
    private StreamConnectionFactory connectionFactory = new DefaultConnectionFactory();
    private boolean flushBeforeTransfer = true;

    public StreamPlan(String description) {
        this.description = description;
    }

    public StreamPlan requestRanges(InetAddress from, InetAddress connecting, String keyspace, Collection<Range<Token>> ranges) {
        return this.requestRanges(from, connecting, keyspace, ranges, new String[0]);
    }

    public StreamPlan requestRanges(InetAddress from, InetAddress connecting, String keyspace, Collection<Range<Token>> ranges, String ... columnFamilies) {
        StreamSession session = this.getOrCreateSession(from, connecting);
        session.addStreamRequest(keyspace, ranges, Arrays.asList(columnFamilies));
        return this;
    }

    public StreamPlan transferRanges(InetAddress to, String keyspace, Collection<Range<Token>> ranges, String ... columnFamilies) {
        return this.transferRanges(to, to, keyspace, ranges, columnFamilies);
    }

    public StreamPlan transferRanges(InetAddress to, InetAddress connecting, String keyspace, Collection<Range<Token>> ranges) {
        return this.transferRanges(to, connecting, keyspace, ranges, new String[0]);
    }

    public StreamPlan transferRanges(InetAddress to, InetAddress connecting, String keyspace, Collection<Range<Token>> ranges, String ... columnFamilies) {
        StreamSession session = this.getOrCreateSession(to, connecting);
        session.addTransferRanges(keyspace, ranges, Arrays.asList(columnFamilies), this.flushBeforeTransfer);
        return this;
    }

    public StreamPlan transferFiles(InetAddress to, Collection<StreamSession.SSTableStreamingSections> sstableDetails) {
        StreamSession session = this.getOrCreateSession(to, to);
        session.addTransferFiles(sstableDetails);
        return this;
    }

    public StreamPlan listeners(StreamEventHandler handler, StreamEventHandler ... handlers) {
        this.handlers.add(handler);
        if (handlers != null) {
            Collections.addAll(this.handlers, handlers);
        }
        return this;
    }

    public StreamPlan connectionFactory(StreamConnectionFactory factory) {
        this.connectionFactory = factory;
        return this;
    }

    public boolean isEmpty() {
        return this.sessions.isEmpty();
    }

    public StreamResultFuture execute() {
        return StreamResultFuture.init(this.planId, this.description, this.sessions.values(), this.handlers);
    }

    public StreamPlan flushBeforeTransfer(boolean flushBeforeTransfer) {
        this.flushBeforeTransfer = flushBeforeTransfer;
        return this;
    }

    private StreamSession getOrCreateSession(InetAddress peer, InetAddress preferred) {
        StreamSession session = this.sessions.get(peer);
        if (session == null) {
            session = new StreamSession(peer, preferred, this.connectionFactory);
            this.sessions.put(peer, session);
        }
        return session;
    }
}

