/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.thrift;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.WriteType;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestExecutionException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestTimeoutException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.WriteTimeoutException;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.AuthenticationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.TimedOutException;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.UnavailableException;

public class ThriftConversion {
    public static com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel fromThrift(ConsistencyLevel cl) {
        switch (cl) {
            case ANY: {
                return com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel.ANY;
            }
            case ONE: {
                return com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel.ONE;
            }
            case TWO: {
                return com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel.TWO;
            }
            case THREE: {
                return com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel.THREE;
            }
            case QUORUM: {
                return com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel.QUORUM;
            }
            case ALL: {
                return com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel.ALL;
            }
            case LOCAL_QUORUM: {
                return com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel.LOCAL_QUORUM;
            }
            case EACH_QUORUM: {
                return com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel.EACH_QUORUM;
            }
            case SERIAL: {
                return com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel.SERIAL;
            }
            case LOCAL_SERIAL: {
                return com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel.LOCAL_SERIAL;
            }
            case LOCAL_ONE: {
                return com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel.LOCAL_ONE;
            }
        }
        throw new AssertionError();
    }

    public static RuntimeException rethrow(RequestExecutionException e) throws UnavailableException, TimedOutException {
        if (e instanceof RequestTimeoutException) {
            throw ThriftConversion.toThrift((RequestTimeoutException)e);
        }
        throw new UnavailableException();
    }

    public static InvalidRequestException toThrift(RequestValidationException e) {
        return new InvalidRequestException(e.getMessage());
    }

    public static InvalidRequestException toThrift(com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException e) {
        return new InvalidRequestException(e.getMessage());
    }

    public static UnavailableException toThrift(com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnavailableException e) {
        return new UnavailableException();
    }

    public static AuthenticationException toThrift(com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.AuthenticationException e) {
        return new AuthenticationException(e.getMessage());
    }

    public static TimedOutException toThrift(RequestTimeoutException e) {
        TimedOutException toe = new TimedOutException();
        if (e instanceof WriteTimeoutException) {
            WriteTimeoutException wte = (WriteTimeoutException)e;
            toe.setAcknowledged_by(wte.received);
            if (wte.writeType == WriteType.BATCH_LOG) {
                toe.setAcknowledged_by_batchlog(false);
            } else if (wte.writeType == WriteType.BATCH) {
                toe.setAcknowledged_by_batchlog(true);
            } else if (wte.writeType == WriteType.CAS) {
                toe.setPaxos_in_progress(true);
            }
        }
        return toe;
    }
}

