/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.transport;

import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Frame;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.ProtocolException;
import java.io.IOException;
import net.jpountz.lz4.LZ4Decompressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyError;

public interface FrameCompressor {
    public Frame compress(Frame var1) throws IOException;

    public Frame decompress(Frame var1) throws IOException;

    public static class LZ4Compressor
    implements FrameCompressor {
        public static final LZ4Compressor instance = new LZ4Compressor();
        private static final int INTEGER_BYTES = 4;
        private final net.jpountz.lz4.LZ4Compressor compressor;
        private final LZ4Decompressor decompressor;

        private LZ4Compressor() {
            LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
            this.compressor = lz4Factory.fastCompressor();
            this.decompressor = lz4Factory.decompressor();
        }

        @Override
        public Frame compress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            int maxCompressedLength = this.compressor.maxCompressedLength(input.length);
            byte[] output = new byte[4 + maxCompressedLength];
            output[0] = (byte)(input.length >>> 24);
            output[1] = (byte)(input.length >>> 16);
            output[2] = (byte)(input.length >>> 8);
            output[3] = (byte)input.length;
            try {
                int written = this.compressor.compress(input, 0, input.length, output, 4, maxCompressedLength);
                return frame.with(ChannelBuffers.wrappedBuffer((byte[])output, (int)0, (int)(4 + written)));
            }
            catch (LZ4Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public Frame decompress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            int uncompressedLength = (input[0] & 0xFF) << 24 | (input[1] & 0xFF) << 16 | (input[2] & 0xFF) << 8 | input[3] & 0xFF;
            byte[] output = new byte[uncompressedLength];
            try {
                int read = this.decompressor.decompress(input, 4, output, 0, uncompressedLength);
                if (read != input.length - 4) {
                    throw new IOException("Compressed lengths mismatch");
                }
                return frame.with(ChannelBuffers.wrappedBuffer((byte[])output));
            }
            catch (LZ4Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static class SnappyCompressor
    implements FrameCompressor {
        public static final SnappyCompressor instance;

        private SnappyCompressor() {
            Snappy.getNativeLibraryVersion();
        }

        @Override
        public Frame compress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            byte[] output = new byte[Snappy.maxCompressedLength((int)input.length)];
            int written = Snappy.compress((byte[])input, (int)0, (int)input.length, (byte[])output, (int)0);
            return frame.with(ChannelBuffers.wrappedBuffer((byte[])output, (int)0, (int)written));
        }

        @Override
        public Frame decompress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            if (!Snappy.isValidCompressedBuffer((byte[])input, (int)0, (int)input.length)) {
                throw new ProtocolException("Provided frame does not appear to be Snappy compressed");
            }
            byte[] output = new byte[Snappy.uncompressedLength((byte[])input)];
            int size = Snappy.uncompress((byte[])input, (int)0, (int)input.length, (byte[])output, (int)0);
            return frame.with(ChannelBuffers.wrappedBuffer((byte[])output, (int)0, (int)size));
        }

        static {
            SnappyCompressor i;
            try {
                i = new SnappyCompressor();
            }
            catch (Exception e) {
                i = null;
            }
            catch (NoClassDefFoundError e) {
                i = null;
            }
            catch (SnappyError e) {
                i = null;
            }
            catch (UnsatisfiedLinkError e) {
                i = null;
            }
            instance = i;
        }
    }
}

