/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.transport;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.EncryptionOptions;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.QueryOptions;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.security.SSLFactory;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Connection;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Frame;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.FrameCompressor;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Message;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.CredentialsMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ErrorMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ExecuteMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.PrepareMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.QueryMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.StartupMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.MD5Digest;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClient {
    private static final Logger logger;
    public final String host;
    public final int port;
    private final EncryptionOptions.ClientEncryptionOptions encryptionOptions;
    protected final ResponseHandler responseHandler = new ResponseHandler();
    protected final Connection.Tracker tracker = new ConnectionTracker();
    protected final Connection connection = new Connection(null, 2, this.tracker);
    protected ClientBootstrap bootstrap;
    protected Channel channel;
    protected ChannelFuture lastWriteFuture;
    private final Connection.Factory connectionFactory = new Connection.Factory(){

        @Override
        public Connection newConnection(Channel channel, int version) {
            assert (version == 2);
            return SimpleClient.this.connection;
        }
    };
    private static final Message.ProtocolDecoder messageDecoder;
    private static final Message.ProtocolEncoder messageEncoder;
    private static final Frame.Decompressor frameDecompressor;
    private static final Frame.Compressor frameCompressor;
    private static final Frame.Encoder frameEncoder;

    public SimpleClient(String host, int port, EncryptionOptions.ClientEncryptionOptions encryptionOptions) {
        this.host = host;
        this.port = port;
        this.encryptionOptions = encryptionOptions;
    }

    public SimpleClient(String host, int port) {
        this(host, port, new EncryptionOptions.ClientEncryptionOptions());
    }

    public void connect(boolean useCompression) throws IOException {
        this.establishConnection();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("CQL_VERSION", "3.0.0");
        if (useCompression) {
            options.put("COMPRESSION", "snappy");
            this.connection.setCompressor(FrameCompressor.SnappyCompressor.instance);
        }
        this.execute(new StartupMessage(options));
    }

    protected void establishConnection() throws IOException {
        this.bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        this.bootstrap.setOption("tcpNoDelay", (Object)true);
        if (this.encryptionOptions.enabled) {
            this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new SecurePipelineFactory());
        } else {
            this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new PipelineFactory());
        }
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
        this.channel = future.awaitUninterruptibly().getChannel();
        if (!future.isSuccess()) {
            this.bootstrap.releaseExternalResources();
            throw new IOException("Connection Error", future.getCause());
        }
    }

    public void login(Map<String, String> credentials) {
        CredentialsMessage msg = new CredentialsMessage();
        msg.credentials.putAll(credentials);
        this.execute(msg);
    }

    public ResultMessage execute(String query, ConsistencyLevel consistency) {
        return this.execute(query, Collections.emptyList(), consistency);
    }

    public ResultMessage execute(String query, List<ByteBuffer> values, ConsistencyLevel consistencyLevel) {
        Message.Response msg = this.execute(new QueryMessage(query, new QueryOptions(consistencyLevel, values)));
        assert (msg instanceof ResultMessage);
        return (ResultMessage)msg;
    }

    public ResultMessage.Prepared prepare(String query) {
        Message.Response msg = this.execute(new PrepareMessage(query));
        assert (msg instanceof ResultMessage.Prepared);
        return (ResultMessage.Prepared)msg;
    }

    public ResultMessage executePrepared(byte[] statementId, List<ByteBuffer> values, ConsistencyLevel consistency) {
        Message.Response msg = this.execute(new ExecuteMessage(MD5Digest.wrap(statementId), new QueryOptions(consistency, values)));
        assert (msg instanceof ResultMessage);
        return (ResultMessage)msg;
    }

    public void close() {
        if (this.lastWriteFuture != null) {
            this.lastWriteFuture.awaitUninterruptibly();
        }
        this.channel.close().awaitUninterruptibly();
        this.bootstrap.releaseExternalResources();
    }

    protected Message.Response execute(Message.Request request) {
        try {
            request.attach(this.connection);
            this.lastWriteFuture = this.channel.write((Object)request);
            Message.Response msg = this.responseHandler.responses.take();
            if (msg instanceof ErrorMessage) {
                throw new RuntimeException((Throwable)((Object)((ErrorMessage)msg).error));
            }
            return msg;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        logger = LoggerFactory.getLogger(SimpleClient.class);
        messageDecoder = new Message.ProtocolDecoder();
        messageEncoder = new Message.ProtocolEncoder();
        frameDecompressor = new Frame.Decompressor();
        frameCompressor = new Frame.Compressor();
        frameEncoder = new Frame.Encoder();
    }

    private static class ResponseHandler
    extends SimpleChannelUpstreamHandler {
        public final BlockingQueue<Message.Response> responses = new SynchronousQueue<Message.Response>(true);

        private ResponseHandler() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            assert (e.getMessage() instanceof Message.Response);
            try {
                this.responses.put((Message.Response)e.getMessage());
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            if (this == ctx.getPipeline().getLast()) {
                logger.error("Exception in response", e.getCause());
            }
            ctx.sendUpstream((ChannelEvent)e);
        }
    }

    private class SecurePipelineFactory
    extends PipelineFactory {
        private final SSLContext sslContext;

        public SecurePipelineFactory() throws IOException {
            this.sslContext = SSLFactory.createSSLContext(SimpleClient.this.encryptionOptions, true);
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            sslEngine.setEnabledCipherSuites(((SimpleClient)SimpleClient.this).encryptionOptions.cipher_suites);
            sslEngine.setEnabledProtocols(SSLFactory.ACCEPTED_PROTOCOLS);
            ChannelPipeline pipeline = super.getPipeline();
            pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(sslEngine));
            return pipeline;
        }
    }

    private class PipelineFactory
    implements ChannelPipelineFactory {
        private PipelineFactory() {
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("frameDecoder", (ChannelHandler)new Frame.Decoder(SimpleClient.this.connectionFactory));
            pipeline.addLast("frameEncoder", (ChannelHandler)frameEncoder);
            pipeline.addLast("frameDecompressor", (ChannelHandler)frameDecompressor);
            pipeline.addLast("frameCompressor", (ChannelHandler)frameCompressor);
            pipeline.addLast("messageDecoder", (ChannelHandler)messageDecoder);
            pipeline.addLast("messageEncoder", (ChannelHandler)messageEncoder);
            pipeline.addLast("handler", (ChannelHandler)SimpleClient.this.responseHandler);
            return pipeline;
        }
    }

    private static class ConnectionTracker
    implements Connection.Tracker {
        private ConnectionTracker() {
        }

        @Override
        public void addConnection(Channel ch, Connection connection) {
        }

        @Override
        public void closeAll() {
        }
    }
}

