/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.Attributes;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.BatchQueryOptions;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQLStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.QueryHandler;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.QueryProcessor;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.BatchStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.ModificationStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.QueryState;
import com.netflix.astyanax.shaded.org.apache.cassandra.tracing.Tracing;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Message;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.ProtocolException;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ErrorMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.MD5Digest;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.UUIDGen;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jboss.netty.buffer.ChannelBuffer;

public class BatchMessage
extends Message.Request {
    public static final Message.Codec<BatchMessage> codec = new Message.Codec<BatchMessage>(){

        @Override
        public BatchMessage decode(ChannelBuffer body, int version) {
            if (version == 1) {
                throw new ProtocolException("BATCH messages are not support in version 1 of the protocol");
            }
            byte type = body.readByte();
            int n = body.readUnsignedShort();
            ArrayList<Object> queryOrIds = new ArrayList<Object>(n);
            ArrayList<List<ByteBuffer>> variables = new ArrayList<List<ByteBuffer>>(n);
            for (int i = 0; i < n; ++i) {
                byte kind = body.readByte();
                if (kind == 0) {
                    queryOrIds.add(CBUtil.readLongString(body));
                } else if (kind == 1) {
                    queryOrIds.add(MD5Digest.wrap(CBUtil.readBytes(body)));
                } else {
                    throw new ProtocolException("Invalid query kind in BATCH messages. Must be 0 or 1 but got " + kind);
                }
                variables.add(CBUtil.readValueList(body));
            }
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
            return new BatchMessage(this.toType(type), queryOrIds, variables, consistency);
        }

        @Override
        public void encode(BatchMessage msg, ChannelBuffer dest, int version) {
            int queries = msg.queryOrIdList.size();
            dest.writeByte((int)this.fromType(msg.type));
            dest.writeShort(queries);
            for (int i = 0; i < queries; ++i) {
                Object q = msg.queryOrIdList.get(i);
                dest.writeByte((int)((byte)(!(q instanceof String) ? 1 : 0)));
                if (q instanceof String) {
                    CBUtil.writeLongString((String)q, dest);
                } else {
                    CBUtil.writeBytes(((MD5Digest)q).bytes, dest);
                }
                CBUtil.writeValueList(msg.values.get(i), dest);
            }
            CBUtil.writeConsistencyLevel(msg.consistency, dest);
        }

        @Override
        public int encodedSize(BatchMessage msg, int version) {
            int size = 3;
            for (int i = 0; i < msg.queryOrIdList.size(); ++i) {
                Object q = msg.queryOrIdList.get(i);
                size += 1 + (q instanceof String ? CBUtil.sizeOfLongString((String)q) : CBUtil.sizeOfBytes(((MD5Digest)q).bytes));
                size += CBUtil.sizeOfValueList(msg.values.get(i));
            }
            return size += CBUtil.sizeOfConsistencyLevel(msg.consistency);
        }

        private BatchStatement.Type toType(byte b) {
            if (b == 0) {
                return BatchStatement.Type.LOGGED;
            }
            if (b == 1) {
                return BatchStatement.Type.UNLOGGED;
            }
            if (b == 2) {
                return BatchStatement.Type.COUNTER;
            }
            throw new ProtocolException("Invalid BATCH message type " + b);
        }

        private byte fromType(BatchStatement.Type type) {
            switch (type) {
                case LOGGED: {
                    return 0;
                }
                case UNLOGGED: {
                    return 1;
                }
                case COUNTER: {
                    return 2;
                }
            }
            throw new AssertionError();
        }
    };
    public final BatchStatement.Type type;
    public final List<Object> queryOrIdList;
    public final List<List<ByteBuffer>> values;
    public final ConsistencyLevel consistency;

    public BatchMessage(BatchStatement.Type type, List<Object> queryOrIdList, List<List<ByteBuffer>> values, ConsistencyLevel consistency) {
        super(Message.Type.BATCH);
        this.type = type;
        this.queryOrIdList = queryOrIdList;
        this.values = values;
        this.consistency = consistency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state) {
        try {
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession();
                Tracing.instance.begin("Execute batch of CQL3 queries", Collections.emptyMap());
            }
            state.getClientState();
            QueryHandler handler = ClientState.getCQLQueryHandler();
            ArrayList<ModificationStatement> statements = new ArrayList<ModificationStatement>(this.queryOrIdList.size());
            boolean hasConditions = false;
            for (int i = 0; i < this.queryOrIdList.size(); ++i) {
                CQLStatement statement;
                Object query = this.queryOrIdList.get(i);
                if (query instanceof String) {
                    statement = QueryProcessor.parseStatement((String)query, state);
                } else {
                    statement = handler.getPrepared((MD5Digest)query);
                    if (statement == null) {
                        throw new PreparedQueryNotFoundException((MD5Digest)query);
                    }
                }
                List<ByteBuffer> queryValues = this.values.get(i);
                if (queryValues.size() != statement.getBoundTerms()) {
                    throw new InvalidRequestException(String.format("There were %d markers(?) in CQL but %d bound variables", statement.getBoundTerms(), queryValues.size()));
                }
                if (!(statement instanceof ModificationStatement)) {
                    throw new InvalidRequestException("Invalid statement in batch: only UPDATE, INSERT and DELETE statements are allowed.");
                }
                ModificationStatement mst = (ModificationStatement)statement;
                hasConditions |= mst.hasConditions();
                if (mst.isCounter()) {
                    if (this.type != BatchStatement.Type.COUNTER) {
                        throw new InvalidRequestException("Cannot include counter statement in a non-counter batch");
                    }
                } else if (this.type == BatchStatement.Type.COUNTER) {
                    throw new InvalidRequestException("Cannot include non-counter statement in a counter batch");
                }
                statements.add(mst);
            }
            BatchStatement batch = new BatchStatement(-1, this.type, statements, Attributes.none(), hasConditions);
            ResultMessage response = handler.processBatch(batch, state, new BatchQueryOptions(this.consistency, this.values, this.queryOrIdList));
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BATCH of [");
        for (int i = 0; i < this.queryOrIdList.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.queryOrIdList.get(i)).append(" with ").append(this.values.get(i).size()).append(" values");
        }
        sb.append("] at consistency ").append((Object)this.consistency);
        return sb.toString();
    }
}

