/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.netflix.astyanax.AbstractColumnListMutation;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.ColumnPath;
import com.netflix.astyanax.serializers.UUIDSerializer;
import java.util.List;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SlicePredicate;

public class ThriftCounterSuperColumnMutationImpl<C>
extends AbstractColumnListMutation<C> {
    private final List<Mutation> mutationList;
    private final ColumnPath<C> path;
    private CounterSuperColumn superColumn;
    private SlicePredicate deletionPredicate;

    public ThriftCounterSuperColumnMutationImpl(long timestamp, List<Mutation> mutationList, ColumnPath<C> path) {
        super(timestamp);
        this.path = path;
        this.mutationList = mutationList;
    }

    public <V> ColumnListMutation<C> putColumn(C columnName, V value, Serializer<V> valueSerializer, Integer ttl) {
        throw new UnsupportedOperationException();
    }

    public ColumnListMutation<C> putEmptyColumn(C columnName, Integer ttl) {
        return this.putColumn(columnName, null, (Serializer)UUIDSerializer.get(), ttl);
    }

    public ColumnListMutation<C> putEmptyColumn(C columnName) {
        return this.putEmptyColumn(columnName, null);
    }

    public ColumnListMutation<C> delete() {
        Deletion d = new Deletion().setSuper_column(this.path.get(0)).setTimestamp(this.timestamp);
        this.mutationList.add(new Mutation().setDeletion(d));
        ++this.timestamp;
        return this;
    }

    public <SC> ColumnListMutation<SC> withSuperColumn(ColumnPath<SC> superColumnPath) {
        throw new UnsupportedOperationException();
    }

    public ColumnListMutation<C> incrementCounterColumn(C columnName, long amount) {
        CounterColumn column = new CounterColumn();
        column.setName(this.path.getSerializer().toByteBuffer(columnName));
        column.setValue(amount);
        if (this.superColumn == null) {
            this.superColumn = new CounterSuperColumn().setName(this.path.get(0));
            Mutation mutation = new Mutation();
            mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setCounter_super_column(this.superColumn));
            this.mutationList.add(mutation);
        }
        this.superColumn.addToColumns(column);
        return this;
    }

    public ColumnListMutation<C> deleteColumn(C columnName) {
        if (this.deletionPredicate == null) {
            this.deletionPredicate = new SlicePredicate();
            Deletion d = new Deletion().setTimestamp(this.timestamp).setSuper_column(this.path.get(0)).setPredicate(this.deletionPredicate);
            this.mutationList.add(new Mutation().setDeletion(d));
        }
        this.deletionPredicate.addToColumn_names(this.path.getSerializer().toByteBuffer(columnName));
        return this;
    }

    public ColumnListMutation<C> setDefaultTtl(Integer ttl) {
        return this;
    }
}

