/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.annotation.ConditionalOnAtlasProperty;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.classreading.AnnotationMetadataReadingVisitor;

public class OnAtlasPropertyCondition
implements Condition {
    private final Logger LOG = LoggerFactory.getLogger(OnAtlasPropertyCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean matches = false;
        String propertyName = (String)metadata.getAnnotationAttributes(ConditionalOnAtlasProperty.class.getName()).get("property");
        boolean isDefault = (Boolean)metadata.getAnnotationAttributes(ConditionalOnAtlasProperty.class.getName()).get("isDefault");
        String className = ((AnnotationMetadataReadingVisitor)metadata).getClassName();
        try {
            Configuration configuration = ApplicationProperties.get();
            String configuredProperty = configuration.getString(propertyName);
            if (StringUtils.isNotEmpty((String)configuredProperty)) {
                matches = configuredProperty.equals(className);
            } else if (isDefault) {
                matches = true;
            }
        }
        catch (AtlasException e) {
            this.LOG.error("Unable to load atlas properties. Dependent bean configuration may fail");
        }
        return matches;
    }
}

