/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus.migration;

import java.util.Map;
import org.apache.atlas.utils.LruCache;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedElementCache {
    private static final Logger LOG = LoggerFactory.getLogger(MappedElementCache.class);
    final Map<Object, Vertex> lruVertexCache = new LruCache(500, 100000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vertex getMappedVertex(Graph gr, Object key) {
        try {
            Vertex ret = this.lruVertexCache.get(key);
            if (ret == null) {
                Map<Object, Vertex> map = this.lruVertexCache;
                synchronized (map) {
                    ret = this.lruVertexCache.get(key);
                    if (ret == null) {
                        ret = this.fetchVertex(gr, key);
                        this.lruVertexCache.put(key, ret);
                    }
                }
            }
            return ret;
        }
        catch (Exception ex) {
            LOG.error("getMappedVertex: {}", key, (Object)ex);
            return null;
        }
    }

    Vertex fetchVertex(Graph gr, Object key) {
        try {
            return (Vertex)gr.traversal().V(new Object[0]).has("__vIdInImport", key).next();
        }
        catch (Exception ex) {
            LOG.error("fetchVertex: fetchFromDB failed: {}", key);
            return null;
        }
    }

    public void clearAll() {
        this.lruVertexCache.clear();
    }
}

