/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasException;
import org.apache.atlas.discovery.SearchAggregator;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.model.discovery.AtlasAggregationEntry;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AggregationContext;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphIndexClient;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAggregatorImpl
implements SearchAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(SearchAggregatorImpl.class);
    private final SearchContext searchContext;

    public SearchAggregatorImpl(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    @Override
    public Map<String, List<AtlasAggregationEntry>> getAggregatedMetrics(Set<String> aggregationFields, Set<AtlasStructType.AtlasAttribute> aggregationAttributes) {
        SearchParameters searchParameters = this.searchContext.getSearchParameters();
        AtlasGraph graph = this.searchContext.getGraph();
        AtlasTypeRegistry typeRegistry = this.searchContext.getTypeRegistry();
        String queryString = searchParameters.getQuery();
        ArrayList<ServiceTypeAggregator> postProcessors = new ArrayList<ServiceTypeAggregator>();
        postProcessors.add(new ServiceTypeAggregator(this.searchContext.getTypeRegistry()));
        try {
            String indexFieldName;
            AtlasGraphIndexClient graphIndexClient = graph.getGraphIndexClient();
            Set<AtlasEntityType> searchForEntityType = this.searchContext.getEntityTypes();
            HashMap<String, String> indexFieldNameCache = new HashMap<String, String>();
            for (String fieldName : aggregationFields) {
                indexFieldName = this.getIndexFieldNameForCommonFieldName(typeRegistry, fieldName);
                indexFieldNameCache.put(fieldName, indexFieldName);
            }
            for (AtlasStructType.AtlasAttribute attribute : aggregationAttributes) {
                indexFieldName = attribute.getIndexFieldName();
                if (indexFieldName == null) {
                    indexFieldName = attribute.getQualifiedName();
                }
                indexFieldNameCache.put(attribute.getQualifiedName(), indexFieldName);
            }
            AggregationContext aggregatorContext = new AggregationContext(queryString, searchParameters.getEntityFilters(), searchForEntityType, aggregationFields, aggregationAttributes, indexFieldNameCache, searchParameters.getExcludeDeletedEntities(), searchParameters.getIncludeSubTypes());
            Map aggregatedMetrics = graphIndexClient.getAggregatedMetrics(aggregatorContext);
            for (String string : aggregatedMetrics.keySet()) {
                for (PostProcessor postProcessor : postProcessors) {
                    if (!postProcessor.needsProcessing(string)) continue;
                    postProcessor.prepareForMetric(string);
                    for (AtlasAggregationEntry aggregationEntry : (List)aggregatedMetrics.get(string)) {
                        postProcessor.process(aggregationEntry);
                    }
                    postProcessor.handleMetricCompletion(string);
                }
            }
            for (PostProcessor postProcessor : postProcessors) {
                postProcessor.handleCompletion(aggregatedMetrics);
            }
            return aggregatedMetrics;
        }
        catch (AtlasException e) {
            LOG.error("Error encountered in post processing stage of aggrgation metrics collection. Empty metrics will be returned.", (Throwable)e);
            return Collections.EMPTY_MAP;
        }
    }

    private String getIndexFieldNameForCommonFieldName(AtlasTypeRegistry typeRegistry, String fieldName) {
        String indexFieldName = typeRegistry.getIndexFieldName(fieldName);
        if (indexFieldName != null) {
            return indexFieldName;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not find index field name from type registry for attribute {}. Will use use the field name as is.", (Object)fieldName);
        }
        return fieldName;
    }

    static class ServiceTypeAggregator
    implements PostProcessor {
        private static final String SERVICE_TYPE = "ServiceType";
        private final AtlasTypeRegistry typeRegistry;
        private final List<AtlasAggregationEntry> entries = new ArrayList<AtlasAggregationEntry>();
        private final Map<String, AtlasAggregationEntry> entityType2MetricsMap = new HashMap<String, AtlasAggregationEntry>();

        public ServiceTypeAggregator(AtlasTypeRegistry typeRegistry) {
            this.typeRegistry = typeRegistry;
        }

        @Override
        public boolean needsProcessing(String metricName) {
            return Constants.ENTITY_TYPE_PROPERTY_KEY.equals(metricName);
        }

        @Override
        public void prepareForMetric(String metricName) {
            HashMap<String, AtlasAggregationEntry> serviceName2MetricsMap = new HashMap<String, AtlasAggregationEntry>();
            for (String serviceName : this.typeRegistry.getAllServiceTypes()) {
                AtlasAggregationEntry serviceMetrics = new AtlasAggregationEntry(serviceName, 0L);
                serviceName2MetricsMap.put(serviceName, serviceMetrics);
                this.entries.add(serviceMetrics);
            }
            for (AtlasEntityType entityType : this.typeRegistry.getAllEntityTypes()) {
                String serviceName = entityType.getServiceType();
                this.entityType2MetricsMap.put(entityType.getTypeName(), (AtlasAggregationEntry)serviceName2MetricsMap.get(serviceName));
            }
        }

        @Override
        public void process(AtlasAggregationEntry aggregationEntryForType) {
            String entityType = aggregationEntryForType.getName();
            AtlasAggregationEntry atlasAggregationEntryForService = this.entityType2MetricsMap.get(entityType);
            if (atlasAggregationEntryForService != null) {
                atlasAggregationEntryForService.setCount(atlasAggregationEntryForService.getCount() + aggregationEntryForType.getCount());
            }
        }

        @Override
        public void handleMetricCompletion(String metricName) {
        }

        @Override
        public void handleCompletion(Map<String, List<AtlasAggregationEntry>> aggregatedMetrics) {
            for (int i = this.entries.size() - 1; i >= 0; --i) {
                if (this.entries.get(i).getCount() != 0L) continue;
                this.entries.remove(i);
            }
            if (CollectionUtils.isNotEmpty(this.entries)) {
                aggregatedMetrics.put(SERVICE_TYPE, this.entries);
            }
        }
    }

    static interface PostProcessor {
        public boolean needsProcessing(String var1);

        public void prepareForMetric(String var1);

        public void process(AtlasAggregationEntry var1);

        public void handleMetricCompletion(String var1);

        public void handleCompletion(Map<String, List<AtlasAggregationEntry>> var1);
    }
}

