/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermSearchProcessor
extends SearchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TermSearchProcessor.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"TermSearchProcessor");
    public static final String ATLAS_GLOSSARY_TERM_ENTITY_TYPE = "AtlasGlossaryTerm";
    public static final String ATLAS_GLOSSARY_TERM_ATTR_QNAME = "qualifiedName";
    public static final String ATLAS_GLOSSARY_TERM_ATTR_ASSIGNED_ENTITIES = "assignedEntities";
    public static final String ATLAS_GLOSSARY_TERM_ATTR_MEANINGS = "meanings";
    final List<AtlasVertex> assignedEntities;

    public TermSearchProcessor(SearchContext context, List<AtlasVertex> assignedEntities) {
        super(context);
        this.assignedEntities = assignedEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AtlasVertex> execute() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TermSearchProcessor.execute({})", (Object)this.context);
        }
        ArrayList<AtlasVertex> ret = new ArrayList<AtlasVertex>();
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("TermSearchProcessor.execute(" + this.context + ")"));
        }
        try {
            if (CollectionUtils.isNotEmpty(this.assignedEntities)) {
                LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap = new LinkedHashMap<Integer, AtlasVertex>();
                int startIdx = this.context.getSearchParameters().getOffset();
                int limit = this.context.getSearchParameters().getLimit();
                ArrayList<AtlasVertex> tmpList = new ArrayList<AtlasVertex>(this.assignedEntities);
                for (int i = 0; i < tmpList.size(); ++i) {
                    offsetEntityVertexMap.put(i, (AtlasVertex)tmpList.get(i));
                }
                offsetEntityVertexMap = super.filter(offsetEntityVertexMap);
                this.collectResultVertices(ret, startIdx, limit, 0, offsetEntityVertexMap, null);
            }
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TermSearchProcessor.execute({}): ret.size()={}", (Object)this.context, (Object)ret.size());
        }
        return ret;
    }

    @Override
    public LinkedHashMap<Integer, AtlasVertex> filter(LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TermSearchProcessor.filter({})", (Object)offsetEntityVertexMap.size());
        }
        if (MapUtils.isNotEmpty(offsetEntityVertexMap)) {
            if (CollectionUtils.isEmpty(this.assignedEntities)) {
                offsetEntityVertexMap.clear();
            } else {
                offsetEntityVertexMap.entrySet().stream().filter((? super T o) -> {
                    if (o instanceof AtlasVertex) {
                        AtlasVertex entityVertex = (AtlasVertex)o;
                        for (AtlasVertex assignedEntity : this.assignedEntities) {
                            if (!assignedEntity.getId().equals(entityVertex.getId())) continue;
                            return true;
                        }
                    }
                    return false;
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedHashMap::new));
            }
        }
        offsetEntityVertexMap = super.filter(offsetEntityVertexMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TermSearchProcessor.filter(): ret.size()={}", (Object)offsetEntityVertexMap.size());
        }
        return offsetEntityVertexMap;
    }

    @Override
    public long getResultCount() {
        return this.assignedEntities != null ? (long)this.assignedEntities.size() : -1L;
    }
}

