/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.RequestContext;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.TransformerContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.impexp.AtlasImportRequest;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.impexp.AuditsWriter;
import org.apache.atlas.repository.impexp.ImportTransforms;
import org.apache.atlas.repository.impexp.ImportTransformsShaper;
import org.apache.atlas.repository.impexp.ImportTypeDefProcessor;
import org.apache.atlas.repository.impexp.TableReplicationRequestProcessor;
import org.apache.atlas.repository.impexp.ZipSource;
import org.apache.atlas.repository.impexp.ZipSourceDirect;
import org.apache.atlas.repository.impexp.ZipSourceWithBackingDirectory;
import org.apache.atlas.repository.store.graph.BulkImporter;
import org.apache.atlas.repository.store.graph.v2.EntityImportStream;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ImportService {
    private static final Logger LOG = LoggerFactory.getLogger(ImportService.class);
    private static final String ATLAS_TYPE_HIVE_TABLE = "hive_table";
    private final AtlasTypeDefStore typeDefStore;
    private final AtlasTypeRegistry typeRegistry;
    private final BulkImporter bulkImporter;
    private final AuditsWriter auditsWriter;
    private final ImportTransformsShaper importTransformsShaper;
    private TableReplicationRequestProcessor tableReplicationRequestProcessor;
    private long startTimestamp;
    private long endTimestamp;

    @Inject
    public ImportService(AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry, BulkImporter bulkImporter, AuditsWriter auditsWriter, ImportTransformsShaper importTransformsShaper, TableReplicationRequestProcessor tableReplicationRequestProcessor) {
        this.typeDefStore = typeDefStore;
        this.typeRegistry = typeRegistry;
        this.bulkImporter = bulkImporter;
        this.auditsWriter = auditsWriter;
        this.importTransformsShaper = importTransformsShaper;
        this.tableReplicationRequestProcessor = tableReplicationRequestProcessor;
    }

    public AtlasImportResult run(InputStream inputStream, String userName, String hostName, String requestingIP) throws AtlasBaseException {
        return this.run(inputStream, null, userName, hostName, requestingIP);
    }

    public AtlasImportResult run(InputStream inputStream, AtlasImportRequest request, String userName, String hostName, String requestingIP) throws AtlasBaseException {
        if (request == null) {
            request = new AtlasImportRequest();
        }
        EntityImportStream source = this.createZipSource(request, inputStream, AtlasConfiguration.IMPORT_TEMP_DIRECTORY.getString());
        return this.run(source, request, userName, hostName, requestingIP);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    AtlasImportResult run(EntityImportStream source, AtlasImportRequest request, String userName, String hostName, String requestingIP) throws AtlasBaseException {
        AtlasImportResult result = new AtlasImportResult(request, userName, requestingIP, hostName, System.currentTimeMillis());
        try {
            LOG.info("==> import(user={}, from={}, request={})", new Object[]{userName, requestingIP, request});
            RequestContext.get().setImportInProgress(true);
            String transforms = MapUtils.isNotEmpty((Map)request.getOptions()) ? (String)request.getOptions().get("transforms") : null;
            this.setImportTransform(source, transforms);
            String transformers = MapUtils.isNotEmpty((Map)request.getOptions()) ? (String)request.getOptions().get("transformers") : null;
            this.setEntityTransformerHandlers(source, transformers);
            this.startTimestamp = System.currentTimeMillis();
            this.processTypes(source.getTypesDef(), result);
            this.setStartPosition(request, source);
            this.processEntities(userName, source, result);
            this.processReplicationDeletion(source.getExportResult().getRequest(), request);
        }
        catch (AtlasBaseException excp) {
            try {
                LOG.error("import(user={}, from={}): failed", new Object[]{userName, requestingIP, excp});
                throw excp;
                catch (Exception excp2) {
                    LOG.error("import(user={}, from={}): failed", new Object[]{userName, requestingIP, excp2});
                    throw new AtlasBaseException((Throwable)excp2);
                }
            }
            catch (Throwable throwable) {
                RequestContext.get().setImportInProgress(false);
                if (source != null) {
                    source.close();
                }
                LOG.info("<== import(user={}, from={}): status={}", new Object[]{userName, requestingIP, result.getOperationStatus()});
                throw throwable;
            }
        }
        RequestContext.get().setImportInProgress(false);
        if (source != null) {
            source.close();
        }
        LOG.info("<== import(user={}, from={}): status={}", new Object[]{userName, requestingIP, result.getOperationStatus()});
        return result;
    }

    @VisibleForTesting
    void setImportTransform(EntityImportStream source, String transforms) throws AtlasBaseException {
        ImportTransforms importTransform = ImportTransforms.fromJson(transforms);
        if (importTransform == null) {
            return;
        }
        this.importTransformsShaper.shape(importTransform, source.getExportResult().getRequest());
        source.setImportTransform(importTransform);
        if (LOG.isDebugEnabled()) {
            this.debugLog("   => transforms: {}", AtlasType.toJson((Object)importTransform));
        }
    }

    @VisibleForTesting
    void setEntityTransformerHandlers(EntityImportStream source, String transformersJson) throws AtlasBaseException {
        if (StringUtils.isEmpty((CharSequence)transformersJson)) {
            return;
        }
        TransformerContext context = new TransformerContext(this.typeRegistry, this.typeDefStore, source.getExportResult().getRequest());
        List<BaseEntityHandler> entityHandlers = BaseEntityHandler.fromJson(transformersJson, context);
        if (CollectionUtils.isEmpty(entityHandlers)) {
            return;
        }
        source.setEntityHandlers(entityHandlers);
    }

    private void debugLog(String s, Object ... params) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(s, params);
    }

    private void setStartPosition(AtlasImportRequest request, EntityImportStream source) throws AtlasBaseException {
        if (request.getStartGuid() != null) {
            source.setPositionUsingEntityGuid(request.getStartGuid());
        } else if (request.getStartPosition() != null) {
            source.setPosition(Integer.parseInt(request.getStartPosition()));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AtlasImportResult run(AtlasImportRequest request, String userName, String hostName, String requestingIP) throws AtlasBaseException {
        String fileName = request.getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"FILENAME parameter not found"});
        }
        AtlasImportResult result = null;
        try {
            LOG.info("==> import(user={}, from={}, fileName={})", new Object[]{userName, requestingIP, fileName});
            File file = new File(fileName);
            result = this.run(new FileInputStream(file), request, userName, hostName, requestingIP);
        }
        catch (AtlasBaseException excp) {
            try {
                LOG.error("import(user={}, from={}, fileName={}): failed", new Object[]{userName, requestingIP, excp});
                throw excp;
                catch (FileNotFoundException excp2) {
                    LOG.error("import(user={}, from={}, fileName={}): file not found", new Object[]{userName, requestingIP, excp2});
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{fileName + ": file not found"});
                }
                catch (Exception excp3) {
                    LOG.error("import(user={}, from={}, fileName={}): failed", new Object[]{userName, requestingIP, excp3});
                    throw new AtlasBaseException((Throwable)excp3);
                }
            }
            catch (Throwable throwable) {
                LOG.info("<== import(user={}, from={}, fileName={}): status={}", new Object[]{userName, requestingIP, fileName, result == null ? AtlasImportResult.OperationStatus.FAIL : result.getOperationStatus()});
                throw throwable;
            }
        }
        LOG.info("<== import(user={}, from={}, fileName={}): status={}", new Object[]{userName, requestingIP, fileName, result == null ? AtlasImportResult.OperationStatus.FAIL : result.getOperationStatus()});
        return result;
    }

    private void processTypes(AtlasTypesDef typeDefinitionMap, AtlasImportResult result) throws AtlasBaseException {
        if (result.getRequest().getUpdateTypeDefs() != null && !result.getRequest().getUpdateTypeDefs().equals("true")) {
            return;
        }
        ImportTypeDefProcessor importTypeDefProcessor = new ImportTypeDefProcessor(this.typeDefStore, this.typeRegistry);
        importTypeDefProcessor.processTypes(typeDefinitionMap, result);
    }

    private void processEntities(String userName, EntityImportStream importSource, AtlasImportResult result) throws AtlasBaseException {
        result.setExportResult(importSource.getExportResult());
        this.bulkImporter.bulkImport(importSource, result);
        this.endTimestamp = System.currentTimeMillis();
        result.incrementMeticsCounter("duration", this.getDuration(this.endTimestamp, this.startTimestamp));
        result.setOperationStatus(AtlasImportResult.OperationStatus.SUCCESS);
        if (this.isMigrationMode(result.getRequest())) {
            return;
        }
        this.auditsWriter.write(userName, result, this.startTimestamp, this.endTimestamp, importSource.getCreationOrder());
    }

    private void processReplicationDeletion(AtlasExportRequest exportRequest, AtlasImportRequest importRequest) throws AtlasBaseException {
        if (this.checkHiveTableIncrementalSkipLineage(importRequest, exportRequest)) {
            this.tableReplicationRequestProcessor.process(exportRequest, importRequest);
        }
    }

    private int getDuration(long endTime, long startTime) {
        return (int)(endTime - startTime);
    }

    private EntityImportStream createZipSource(AtlasImportRequest request, InputStream inputStream, String configuredTemporaryDirectory) throws AtlasBaseException {
        try {
            if (this.isMigrationMode(request) || request.getOptions().containsKey("format") && ((String)request.getOptions().get("format")).equals("zipDirect")) {
                LOG.info("ZipSource Format: ZipDirect: Size: {}", request.getOptions().get("size"));
                return this.getZipDirectEntityImportStream(request, inputStream);
            }
            if (StringUtils.isEmpty((CharSequence)configuredTemporaryDirectory)) {
                return new ZipSource(inputStream);
            }
            return new ZipSourceWithBackingDirectory(inputStream, configuredTemporaryDirectory);
        }
        catch (IOException ex) {
            throw new AtlasBaseException((Throwable)ex);
        }
    }

    private EntityImportStream getZipDirectEntityImportStream(AtlasImportRequest request, InputStream inputStream) throws IOException, AtlasBaseException {
        ZipSourceDirect zipSourceDirect = new ZipSourceDirect(inputStream, request.getSizeOption());
        LOG.info("Using ZipSourceDirect: Size: {} entities", (Object)zipSourceDirect.size());
        return zipSourceDirect;
    }

    @VisibleForTesting
    boolean checkHiveTableIncrementalSkipLineage(AtlasImportRequest importRequest, AtlasExportRequest exportRequest) {
        if (exportRequest == null || CollectionUtils.isEmpty((Collection)exportRequest.getItemsToExport())) {
            return false;
        }
        for (AtlasObjectId itemToExport : exportRequest.getItemsToExport()) {
            if (itemToExport.getTypeName().equalsIgnoreCase(ATLAS_TYPE_HIVE_TABLE)) continue;
            return false;
        }
        return importRequest.isReplicationOptionSet() && exportRequest.isReplicationOptionSet() && exportRequest.getFetchTypeOptionValue().equalsIgnoreCase("incremental") && exportRequest.getSkipLineageOptionValue();
    }

    private boolean isMigrationMode(AtlasImportRequest request) {
        return request.getOptions().containsKey("migration");
    }
}

