/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.ogm;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.audit.AtlasAuditEntry;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.ogm.AbstractDataTransferObject;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.springframework.stereotype.Component;

@Component
public class AtlasAuditEntryDTO
extends AbstractDataTransferObject<AtlasAuditEntry> {
    public static final String ATTRIBUTE_USER_NAME = "userName";
    public static final String ATTRIBUTE_OPERATION = "operation";
    public static final String ATTRIBUTE_PARAMS = "params";
    public static final String ATTRIBUTE_START_TIME = "startTime";
    public static final String ATTRIBUTE_END_TIME = "endTime";
    public static final String ATTRIBUTE_CLIENT_ID = "clientId";
    public static final String ATTRIBUTE_RESULT = "result";
    public static final String ATTRIBUTE_RESULT_COUNT = "resultCount";
    private static final Set<String> ATTRIBUTE_NAMES = new HashSet<String>(Arrays.asList("userName", "operation", "params", "startTime", "endTime", "clientId", "result", "resultCount"));

    @Inject
    public AtlasAuditEntryDTO(AtlasTypeRegistry typeRegistry) {
        super(typeRegistry, AtlasAuditEntry.class, "__" + AtlasAuditEntry.class.getSimpleName());
    }

    public static Set<String> getAttributes() {
        return ATTRIBUTE_NAMES;
    }

    public static AtlasAuditEntry from(String guid, Map<String, Object> attributes) {
        AtlasAuditEntry entry = new AtlasAuditEntry();
        entry.setGuid(guid);
        entry.setUserName((String)attributes.get(ATTRIBUTE_USER_NAME));
        entry.setOperation(AtlasAuditEntry.AuditOperation.valueOf((String)((String)attributes.get(ATTRIBUTE_OPERATION))));
        entry.setParams((String)attributes.get(ATTRIBUTE_PARAMS));
        entry.setStartTime((Date)attributes.get(ATTRIBUTE_START_TIME));
        entry.setEndTime((Date)attributes.get(ATTRIBUTE_END_TIME));
        entry.setClientId((String)attributes.get(ATTRIBUTE_CLIENT_ID));
        entry.setResult((String)attributes.get(ATTRIBUTE_RESULT));
        entry.setResultCount(((Long)attributes.get(ATTRIBUTE_RESULT_COUNT)).longValue());
        return entry;
    }

    @Override
    public AtlasAuditEntry from(AtlasEntity entity) {
        return AtlasAuditEntryDTO.from(entity.getGuid(), entity.getAttributes());
    }

    @Override
    public AtlasAuditEntry from(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        return this.from(entityWithExtInfo.getEntity());
    }

    @Override
    public AtlasEntity toEntity(AtlasAuditEntry obj) {
        AtlasEntity entity = this.getDefaultAtlasEntity(obj);
        entity.setAttribute(ATTRIBUTE_USER_NAME, (Object)obj.getUserName());
        entity.setAttribute(ATTRIBUTE_OPERATION, (Object)obj.getOperation());
        entity.setAttribute(ATTRIBUTE_PARAMS, (Object)obj.getParams());
        entity.setAttribute(ATTRIBUTE_START_TIME, (Object)obj.getStartTime());
        entity.setAttribute(ATTRIBUTE_END_TIME, (Object)obj.getEndTime());
        entity.setAttribute(ATTRIBUTE_CLIENT_ID, (Object)obj.getClientId());
        entity.setAttribute(ATTRIBUTE_RESULT, (Object)obj.getResult());
        entity.setAttribute(ATTRIBUTE_RESULT_COUNT, (Object)obj.getResultCount());
        return entity;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo toEntityWithExtInfo(AtlasAuditEntry obj) throws AtlasBaseException {
        return new AtlasEntity.AtlasEntityWithExtInfo(this.toEntity(obj));
    }

    @Override
    public Map<String, Object> getUniqueAttributes(AtlasAuditEntry obj) {
        return null;
    }
}

