/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph;

import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityCorrelationStore {
    private static final Logger LOG = LoggerFactory.getLogger(EntityCorrelationStore.class);

    @GraphTransaction
    public void add(String entityGuid, long messageTimestamp) {
        AtlasVertex v = AtlasGraphUtilsV2.findByGuid(entityGuid);
        if (v == null) {
            LOG.warn("Fetching: {} did not yield result!", (Object)entityGuid);
            return;
        }
        AtlasGraphUtilsV2.setEncodedProperty(v, Constants.ENTITY_DELETED_TIMESTAMP_PROPERTY_KEY, messageTimestamp);
        LOG.info("Updating: {}: {}", (Object)entityGuid, (Object)messageTimestamp);
    }

    public String findCorrelatedGuid(String qualifiedName, long messageTimestamp) {
        String guid = AtlasGraphUtilsV2.findFirstDeletedDuringSpooledByQualifiedName(qualifiedName, messageTimestamp);
        LOG.info("findCorrelatedGuid: {} - {} -> {}", new Object[]{qualifiedName, messageTimestamp, guid});
        return guid;
    }
}

