/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.filters;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.web.filters.AtlasResponseRequestWrapper;
import org.apache.commons.configuration.Configuration;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlasCSRFPreventionFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasCSRFPreventionFilter.class);
    private static Configuration configuration;
    public static final boolean isCSRF_ENABLED;
    public static final String BROWSER_USER_AGENT_PARAM = "atlas.rest-csrf.browser-useragents-regex";
    public static final String BROWSER_USER_AGENTS_DEFAULT = "^Mozilla.*,^Opera.*,^Chrome";
    public static final String CUSTOM_METHODS_TO_IGNORE_PARAM = "atlas.rest-csrf.methods-to-ignore";
    public static final String METHODS_TO_IGNORE_DEFAULT = "GET,OPTIONS,HEAD,TRACE";
    public static final String CUSTOM_HEADER_PARAM = "atlas.rest-csrf.custom-header";
    public static final String HEADER_DEFAULT = "X-XSRF-HEADER";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String CSRF_TOKEN = "_csrfToken";
    private String headerName = "X-XSRF-HEADER";
    private Set<String> methodsToIgnore = null;
    private Set<Pattern> browserUserAgents;

    public AtlasCSRFPreventionFilter() {
        try {
            if (isCSRF_ENABLED) {
                this.init(null);
            }
        }
        catch (Exception e) {
            LOG.error("Error while initializing Filter ", (Throwable)e);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String customMethodsToIgnore;
        String customHeader = configuration.getString(CUSTOM_HEADER_PARAM, HEADER_DEFAULT);
        if (customHeader != null) {
            this.headerName = customHeader;
        }
        if ((customMethodsToIgnore = configuration.getString(CUSTOM_METHODS_TO_IGNORE_PARAM, METHODS_TO_IGNORE_DEFAULT)) != null) {
            this.parseMethodsToIgnore(customMethodsToIgnore);
        } else {
            this.parseMethodsToIgnore(METHODS_TO_IGNORE_DEFAULT);
        }
        String agents = configuration.getString(BROWSER_USER_AGENT_PARAM, BROWSER_USER_AGENTS_DEFAULT);
        if (agents == null) {
            agents = BROWSER_USER_AGENTS_DEFAULT;
        }
        this.parseBrowserUserAgents(agents);
        LOG.info("Adding cross-site request forgery (CSRF) protection");
    }

    void parseMethodsToIgnore(String mti) {
        String[] methods = mti.split(",");
        this.methodsToIgnore = new HashSet<String>();
        Collections.addAll(this.methodsToIgnore, methods);
    }

    void parseBrowserUserAgents(String userAgents) {
        String[] agentsArray = userAgents.split(",");
        this.browserUserAgents = new HashSet<Pattern>();
        for (String patternString : agentsArray) {
            this.browserUserAgents.add(Pattern.compile(patternString));
        }
    }

    protected boolean isBrowser(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        if (this.browserUserAgents != null) {
            for (Pattern pattern : this.browserUserAgents) {
                Matcher matcher = pattern.matcher(userAgent);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void handleHttpInteraction(HttpInteraction httpInteraction) throws IOException, ServletException {
        HttpSession session = ((ServletFilterHttpInteraction)httpInteraction).getSession();
        String csrfToken = "";
        if (session != null) {
            csrfToken = (String)session.getAttribute(CSRF_TOKEN);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Session is null");
        }
        String clientCsrfToken = httpInteraction.getHeader(this.headerName);
        if (!this.isBrowser(httpInteraction.getHeader(HEADER_USER_AGENT)) || this.methodsToIgnore.contains(httpInteraction.getMethod()) || clientCsrfToken != null && clientCsrfToken.equals(csrfToken)) {
            httpInteraction.proceed();
        } else {
            httpInteraction.sendError(400, "Missing header or invalid Header value for CSRF Vulnerability Protection");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        AtlasResponseRequestWrapper responseWrapper = new AtlasResponseRequestWrapper(httpResponse);
        if (isCSRF_ENABLED) {
            this.handleHttpInteraction(new ServletFilterHttpInteraction(httpRequest, httpResponse, chain));
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    static {
        try {
            configuration = ApplicationProperties.get();
            LOG.info("Configuration obtained :: " + configuration);
        }
        catch (AtlasException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        isCSRF_ENABLED = configuration.getBoolean("atlas.rest-csrf.enabled", true);
    }

    private static final class ServletFilterHttpInteraction
    implements HttpInteraction {
        private final FilterChain chain;
        private final HttpServletRequest httpRequest;
        private final HttpServletResponse httpResponse;

        public ServletFilterHttpInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) {
            this.httpRequest = httpRequest;
            this.httpResponse = httpResponse;
            this.chain = chain;
        }

        @Override
        public String getHeader(String header) {
            return this.httpRequest.getHeader(header);
        }

        @Override
        public String getMethod() {
            return this.httpRequest.getMethod();
        }

        @Override
        public void proceed() throws IOException, ServletException {
            this.chain.doFilter((ServletRequest)this.httpRequest, (ServletResponse)this.httpResponse);
        }

        public HttpSession getSession() {
            return this.httpRequest.getSession();
        }

        @Override
        public void sendError(int code, String message) throws IOException {
            JSONObject json = new JSONObject();
            json.put((Object)"msgDesc", (Object)message);
            this.httpResponse.setContentType("application/json");
            this.httpResponse.setStatus(code);
            this.httpResponse.setCharacterEncoding("UTF-8");
            this.httpResponse.getWriter().write(json.toJSONString());
        }
    }

    public static interface HttpInteraction {
        public String getHeader(String var1);

        public String getMethod();

        public void proceed() throws IOException, ServletException;

        public void sendError(int var1, String var2) throws IOException;
    }
}

