/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;

public final class DateTimeHelper {
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String DATE_PATTERN = "(2\\d\\d\\d|19\\d\\d)-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])T([0-1][0-9]|2[0-3]):([0-5][0-9])Z";
    private static final Pattern PATTERN = Pattern.compile("(2\\d\\d\\d|19\\d\\d)-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])T([0-1][0-9]|2[0-3]):([0-5][0-9])Z");
    private static ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DateTimeHelper.ISO8601_FORMAT);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };

    private DateTimeHelper() {
    }

    public static DateFormat getDateFormat() {
        return DATE_FORMAT.get();
    }

    public static String formatDateUTC(Date date) {
        return date != null ? DateTimeHelper.getDateFormat().format(date) : null;
    }
}

