/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.LinkedList;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.apache.cassandra.cql3.ErrorListener;
import org.apache.cassandra.exceptions.SyntaxException;

public final class ErrorCollector
implements ErrorListener {
    private static final int FIRST_TOKEN_OFFSET = 10;
    private static final int LAST_TOKEN_OFFSET = 2;
    private final String query;
    private final LinkedList<String> errorMsgs = new LinkedList();

    public ErrorCollector(String query) {
        this.query = query;
    }

    @Override
    public void syntaxError(BaseRecognizer recognizer, String[] tokenNames, RecognitionException e) {
        String hdr = recognizer.getErrorHeader(e);
        String msg = recognizer.getErrorMessage(e, tokenNames);
        StringBuilder builder = new StringBuilder().append(hdr).append(' ').append(msg);
        if (recognizer instanceof Parser) {
            this.appendQuerySnippet((Parser)recognizer, builder);
        }
        this.errorMsgs.add(builder.toString());
    }

    @Override
    public void syntaxError(BaseRecognizer recognizer, String errorMsg) {
        this.errorMsgs.add(errorMsg);
    }

    public void throwLastSyntaxError() throws SyntaxException {
        if (!this.errorMsgs.isEmpty()) {
            throw new SyntaxException(this.errorMsgs.getLast());
        }
    }

    private void appendQuerySnippet(Parser parser, StringBuilder builder) {
        TokenStream tokenStream = parser.getTokenStream();
        int index = tokenStream.index();
        int size = tokenStream.size();
        Token from = tokenStream.get(ErrorCollector.getSnippetFirstTokenIndex(index));
        Token to = tokenStream.get(ErrorCollector.getSnippetLastTokenIndex(index, size));
        Token offending = tokenStream.get(ErrorCollector.getOffendingTokenIndex(index, size));
        this.appendSnippet(builder, from, to, offending);
    }

    final void appendSnippet(StringBuilder builder, Token from, Token to, Token offending) {
        if (!ErrorCollector.areTokensValid(from, to, offending)) {
            return;
        }
        String[] lines = this.query.split("\n");
        boolean includeQueryStart = from.getLine() == 1 && from.getCharPositionInLine() == 0;
        boolean includeQueryEnd = to.getLine() == lines.length && ErrorCollector.getLastCharPositionInLine(to) == lines[lines.length - 1].length();
        builder.append(" (");
        if (!includeQueryStart) {
            builder.append("...");
        }
        lines[ErrorCollector.lineIndex((Token)to)] = lines[ErrorCollector.lineIndex(to)].substring(0, ErrorCollector.getLastCharPositionInLine(to));
        lines[ErrorCollector.lineIndex((Token)offending)] = ErrorCollector.highlightToken(lines[ErrorCollector.lineIndex(offending)], offending);
        lines[ErrorCollector.lineIndex((Token)from)] = lines[ErrorCollector.lineIndex(from)].substring(from.getCharPositionInLine());
        int m = ErrorCollector.lineIndex(to);
        for (int i = ErrorCollector.lineIndex(from); i <= m; ++i) {
            builder.append(lines[i]);
        }
        if (!includeQueryEnd) {
            builder.append("...");
        }
        builder.append(")");
    }

    private static boolean areTokensValid(Token ... tokens) {
        for (Token token : tokens) {
            if (ErrorCollector.isTokenValid(token)) continue;
            return false;
        }
        return true;
    }

    private static boolean isTokenValid(Token token) {
        return token.getLine() > 0 && token.getCharPositionInLine() >= 0;
    }

    private static int getOffendingTokenIndex(int index, int size) {
        return Math.min(index, size - 1);
    }

    private static String highlightToken(String line, Token token) {
        String newLine = ErrorCollector.insertChar(line, ErrorCollector.getLastCharPositionInLine(token), ']');
        return ErrorCollector.insertChar(newLine, token.getCharPositionInLine(), '[');
    }

    private static int getLastCharPositionInLine(Token token) {
        return token.getCharPositionInLine() + ErrorCollector.getLength(token);
    }

    private static int getLength(Token token) {
        return token.getText().length();
    }

    private static String insertChar(String s, int index, char c) {
        return s.substring(0, index) + c + s.substring(index);
    }

    private static int lineIndex(Token token) {
        return token.getLine() - 1;
    }

    private static int getSnippetLastTokenIndex(int index, int size) {
        return Math.min(size - 1, index + 2);
    }

    private static int getSnippetFirstTokenIndex(int index) {
        return Math.max(0, index - 10);
    }
}

