/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Joiner;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.SetSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class Sets {
    private Sets() {
    }

    public static ColumnSpecification valueSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("value(" + column.name + ")", true), ((SetType)column.type).getElementsType());
    }

    public static class ElementDiscarder
    extends Operation {
        public ElementDiscarder(ColumnDefinition column, Term k) {
            super(column, k);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to delete a single element in a frozen set";
            Term.Terminal elt = this.t.bind(params.options);
            if (elt == null) {
                throw new InvalidRequestException("Invalid null set element");
            }
            CellName cellName = cf.getComparator().create(prefix, this.column, elt.get(params.options));
            cf.addColumn(params.makeTombstone(cellName));
        }
    }

    public static class Discarder
    extends Operation {
        public Discarder(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to remove items from a frozen set";
            Term.Terminal value = this.t.bind(params.options);
            if (value == null) {
                return;
            }
            SortedSet<ByteBuffer> toDiscard = value instanceof Value ? ((Value)value).elements : Collections.singleton(value.get(params.options));
            for (ByteBuffer bb : toDiscard) {
                cf.addColumn(params.makeTombstone(cf.getComparator().create(prefix, this.column, bb)));
            }
        }
    }

    public static class Adder
    extends Operation {
        public Adder(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to add items to a frozen set";
            Adder.doAdd(this.t, cf, prefix, this.column, params);
        }

        static void doAdd(Term t, ColumnFamily cf, Composite prefix, ColumnDefinition column, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = t.bind(params.options);
            Value setValue = (Value)value;
            if (column.type.isMultiCell()) {
                if (value == null) {
                    return;
                }
                SortedSet<ByteBuffer> toAdd = setValue.elements;
                for (ByteBuffer bb : toAdd) {
                    CellName cellName = cf.getComparator().create(prefix, column, bb);
                    cf.addColumn(params.makeColumn(cellName, ByteBufferUtil.EMPTY_BYTE_BUFFER));
                }
            } else {
                CellName cellName = cf.getComparator().create(prefix, column);
                if (value == null) {
                    cf.addAtom(params.makeTombstone(cellName));
                } else {
                    cf.addColumn(params.makeColumn(cellName, ((Value)value).getWithProtocolVersion(3)));
                }
            }
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, Composite prefix, UpdateParameters params) throws InvalidRequestException {
            if (this.column.type.isMultiCell()) {
                CellName name = cf.getComparator().create(prefix, this.column);
                cf.addAtom(params.makeTombstoneForOverwrite(name.slice()));
            }
            Adder.doAdd(this.t, cf, prefix, this.column, params);
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type instanceof SetType);
        }

        @Override
        public Value bind(QueryOptions options) throws InvalidRequestException {
            ByteBuffer value = options.getValues().get(this.bindIndex);
            return value == null ? null : Value.fromSerialized(value, (SetType)this.receiver.type, options.getProtocolVersion());
        }
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        private final Comparator<ByteBuffer> comparator;
        private final Set<Term> elements;

        public DelayedValue(Comparator<ByteBuffer> comparator, Set<Term> elements) {
            this.comparator = comparator;
            this.elements = elements;
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public Value bind(QueryOptions options) throws InvalidRequestException {
            TreeSet<ByteBuffer> buffers = new TreeSet<ByteBuffer>(this.comparator);
            for (Term t : this.elements) {
                ByteBuffer bytes = t.bindAndGet(options);
                if (bytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (bytes.remaining() > 65535) {
                    throw new InvalidRequestException(String.format("Set value is too long. Set values are limited to %d bytes but %d bytes value provided", 65535, bytes.remaining()));
                }
                buffers.add(bytes);
            }
            return new Value(buffers);
        }
    }

    public static class Value
    extends Term.Terminal
    implements Term.CollectionTerminal {
        public final SortedSet<ByteBuffer> elements;

        public Value(SortedSet<ByteBuffer> elements) {
            this.elements = elements;
        }

        public static Value fromSerialized(ByteBuffer value, SetType type, int version) throws InvalidRequestException {
            try {
                Object s = ((SetSerializer)type.getSerializer()).deserializeForNativeProtocol(value, version);
                TreeSet<ByteBuffer> elements = new TreeSet<ByteBuffer>(type.getElementsType());
                Iterator iterator = s.iterator();
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    elements.add(type.getElementsType().decompose(element));
                }
                return new Value(elements);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public ByteBuffer get(QueryOptions options) {
            return this.getWithProtocolVersion(options.getProtocolVersion());
        }

        @Override
        public ByteBuffer getWithProtocolVersion(int protocolVersion) {
            return CollectionSerializer.pack(new ArrayList<ByteBuffer>(this.elements), this.elements.size(), protocolVersion);
        }

        public boolean equals(SetType st, Value v) {
            if (this.elements.size() != v.elements.size()) {
                return false;
            }
            Iterator thisIter = this.elements.iterator();
            Iterator thatIter = v.elements.iterator();
            AbstractType elementsType = st.getElementsType();
            while (thisIter.hasNext()) {
                if (elementsType.compare(thisIter.next(), thatIter.next()) == 0) continue;
                return false;
            }
            return true;
        }
    }

    public static class Literal
    implements Term.Raw {
        private final List<Term.Raw> elements;

        public Literal(List<Term.Raw> elements) {
            this.elements = elements;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(keyspace, receiver);
            if (receiver.type instanceof MapType && this.elements.isEmpty()) {
                return new Maps.Value(Collections.emptyMap());
            }
            ColumnSpecification valueSpec = Sets.valueSpecOf(receiver);
            HashSet<Term> values = new HashSet<Term>(this.elements.size());
            boolean allTerminal = true;
            for (Term.Raw rt : this.elements) {
                Term t = rt.prepare(keyspace, valueSpec);
                if (t.containsBindMarker()) {
                    throw new InvalidRequestException(String.format("Invalid set literal for %s: bind variables are not supported inside collection literals", receiver.name));
                }
                if (t instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.add(t);
            }
            DelayedValue value = new DelayedValue(((SetType)receiver.type).getElementsType(), values);
            return allTerminal ? value.bind(QueryOptions.DEFAULT) : value;
        }

        private void validateAssignableTo(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof SetType)) {
                if (receiver.type instanceof MapType && this.elements.isEmpty()) {
                    return;
                }
                throw new InvalidRequestException(String.format("Invalid set literal for %s of type %s", receiver.name, receiver.type.asCQL3Type()));
            }
            ColumnSpecification valueSpec = Sets.valueSpecOf(receiver);
            for (Term.Raw rt : this.elements) {
                if (rt.isAssignableTo(keyspace, valueSpec)) continue;
                throw new InvalidRequestException(String.format("Invalid set literal for %s: value %s is not of type %s", receiver.name, rt, valueSpec.type.asCQL3Type()));
            }
        }

        @Override
        public boolean isAssignableTo(String keyspace, ColumnSpecification receiver) {
            try {
                this.validateAssignableTo(keyspace, receiver);
                return true;
            }
            catch (InvalidRequestException e) {
                return false;
            }
        }

        public String toString() {
            return "{" + Joiner.on((String)", ").join(this.elements) + "}";
        }
    }
}

