/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractData;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SettableData;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class BoundStatement
extends Statement
implements SettableData<BoundStatement>,
GettableData {
    static final ByteBuffer UNSET = ByteBuffer.allocate(0);
    final PreparedStatement statement;
    final DataWrapper wrapper;
    private final CodecRegistry codecRegistry;
    private ByteBuffer routingKey;

    public BoundStatement(PreparedStatement statement) {
        this.statement = statement;
        this.wrapper = new DataWrapper(this, statement.getVariables().size());
        for (int i = 0; i < this.wrapper.values.length; ++i) {
            this.wrapper.values[i] = UNSET;
        }
        if (statement.getConsistencyLevel() != null) {
            this.setConsistencyLevel(statement.getConsistencyLevel());
        }
        if (statement.getSerialConsistencyLevel() != null) {
            this.setSerialConsistencyLevel(statement.getSerialConsistencyLevel());
        }
        if (statement.isTracing()) {
            this.enableTracing();
        }
        if (statement.getRetryPolicy() != null) {
            this.setRetryPolicy(statement.getRetryPolicy());
        }
        if (statement.getOutgoingPayload() != null) {
            this.setOutgoingPayload(statement.getOutgoingPayload());
        } else {
            this.setOutgoingPayload(statement.getIncomingPayload());
        }
        this.codecRegistry = statement.getCodecRegistry();
        if (statement.isIdempotent() != null) {
            this.setIdempotent(statement.isIdempotent());
        }
    }

    public PreparedStatement preparedStatement() {
        return this.statement;
    }

    public boolean isSet(int i) {
        return this.wrapper.getValue(i) != UNSET;
    }

    public boolean isSet(String name) {
        return this.wrapper.getValue(this.wrapper.getIndexOf(name)) != UNSET;
    }

    public void unset(int i) {
        this.wrapper.setValue(i, UNSET);
    }

    public void unset(String name) {
        for (int i : this.wrapper.getAllIndexesOf(name)) {
            this.wrapper.setValue(i, UNSET);
        }
    }

    public BoundStatement bind(Object ... values) {
        if (values.length > this.statement.getVariables().size()) {
            throw new IllegalArgumentException(String.format("Prepared statement has only %d variables, %d values provided", this.statement.getVariables().size(), values.length));
        }
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value == null) {
                this.wrapper.values[i] = null;
                continue;
            }
            ProtocolVersion protocolVersion = this.statement.getPreparedId().protocolVersion;
            this.wrapper.values[i] = value instanceof Token ? ((Token)value).serialize(protocolVersion) : this.wrapper.codecFor(i, value).serialize(value, protocolVersion);
        }
        return this;
    }

    @Override
    public ByteBuffer getRoutingKey(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        if (this.routingKey != null) {
            return this.routingKey;
        }
        if (this.statement.getRoutingKey() != null) {
            return this.statement.getRoutingKey();
        }
        int[] rkIndexes = this.statement.getPreparedId().routingKeyIndexes;
        if (rkIndexes != null) {
            if (rkIndexes.length == 1) {
                return this.wrapper.values[rkIndexes[0]];
            }
            ByteBuffer[] components = new ByteBuffer[rkIndexes.length];
            for (int i = 0; i < components.length; ++i) {
                ByteBuffer value = this.wrapper.values[rkIndexes[i]];
                if (value == null) {
                    return null;
                }
                components[i] = value;
            }
            return SimpleStatement.compose(components);
        }
        return null;
    }

    public BoundStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    public BoundStatement setRoutingKey(ByteBuffer ... routingKeyComponents) {
        this.routingKey = SimpleStatement.compose(routingKeyComponents);
        return this;
    }

    @Override
    public String getKeyspace() {
        return this.statement.getPreparedId().metadata.size() == 0 ? null : this.statement.getPreparedId().metadata.getKeyspace(0);
    }

    @Override
    public BoundStatement setBool(int i, boolean v) {
        return (BoundStatement)this.wrapper.setBool(i, v);
    }

    @Override
    public BoundStatement setBool(String name, boolean v) {
        return (BoundStatement)this.wrapper.setBool(name, v);
    }

    @Override
    public BoundStatement setByte(int i, byte v) {
        return (BoundStatement)this.wrapper.setByte(i, v);
    }

    @Override
    public BoundStatement setByte(String name, byte v) {
        return (BoundStatement)this.wrapper.setByte(name, v);
    }

    @Override
    public BoundStatement setShort(int i, short v) {
        return (BoundStatement)this.wrapper.setShort(i, v);
    }

    @Override
    public BoundStatement setShort(String name, short v) {
        return (BoundStatement)this.wrapper.setShort(name, v);
    }

    @Override
    public BoundStatement setInt(int i, int v) {
        return (BoundStatement)this.wrapper.setInt(i, v);
    }

    @Override
    public BoundStatement setInt(String name, int v) {
        return (BoundStatement)this.wrapper.setInt(name, v);
    }

    @Override
    public BoundStatement setLong(int i, long v) {
        return (BoundStatement)this.wrapper.setLong(i, v);
    }

    @Override
    public BoundStatement setLong(String name, long v) {
        return (BoundStatement)this.wrapper.setLong(name, v);
    }

    @Override
    public BoundStatement setTimestamp(int i, Date v) {
        return (BoundStatement)this.wrapper.setTimestamp(i, v);
    }

    @Override
    public BoundStatement setTimestamp(String name, Date v) {
        return (BoundStatement)this.wrapper.setTimestamp(name, v);
    }

    @Override
    public BoundStatement setDate(int i, LocalDate v) {
        return (BoundStatement)this.wrapper.setDate(i, v);
    }

    @Override
    public BoundStatement setDate(String name, LocalDate v) {
        return (BoundStatement)this.wrapper.setDate(name, v);
    }

    @Override
    public BoundStatement setTime(int i, long v) {
        return (BoundStatement)this.wrapper.setTime(i, v);
    }

    @Override
    public BoundStatement setTime(String name, long v) {
        return (BoundStatement)this.wrapper.setTime(name, v);
    }

    @Override
    public BoundStatement setFloat(int i, float v) {
        return (BoundStatement)this.wrapper.setFloat(i, v);
    }

    @Override
    public BoundStatement setFloat(String name, float v) {
        return (BoundStatement)this.wrapper.setFloat(name, v);
    }

    @Override
    public BoundStatement setDouble(int i, double v) {
        return (BoundStatement)this.wrapper.setDouble(i, v);
    }

    @Override
    public BoundStatement setDouble(String name, double v) {
        return (BoundStatement)this.wrapper.setDouble(name, v);
    }

    @Override
    public BoundStatement setString(int i, String v) {
        return (BoundStatement)this.wrapper.setString(i, v);
    }

    @Override
    public BoundStatement setString(String name, String v) {
        return (BoundStatement)this.wrapper.setString(name, v);
    }

    @Override
    public BoundStatement setBytes(int i, ByteBuffer v) {
        return (BoundStatement)this.wrapper.setBytes(i, v);
    }

    @Override
    public BoundStatement setBytes(String name, ByteBuffer v) {
        return (BoundStatement)this.wrapper.setBytes(name, v);
    }

    @Override
    public BoundStatement setBytesUnsafe(int i, ByteBuffer v) {
        return (BoundStatement)this.wrapper.setBytesUnsafe(i, v);
    }

    @Override
    public BoundStatement setBytesUnsafe(String name, ByteBuffer v) {
        return (BoundStatement)this.wrapper.setBytesUnsafe(name, v);
    }

    @Override
    public BoundStatement setVarint(int i, BigInteger v) {
        return (BoundStatement)this.wrapper.setVarint(i, v);
    }

    @Override
    public BoundStatement setVarint(String name, BigInteger v) {
        return (BoundStatement)this.wrapper.setVarint(name, v);
    }

    @Override
    public BoundStatement setDecimal(int i, BigDecimal v) {
        return (BoundStatement)this.wrapper.setDecimal(i, v);
    }

    @Override
    public BoundStatement setDecimal(String name, BigDecimal v) {
        return (BoundStatement)this.wrapper.setDecimal(name, v);
    }

    @Override
    public BoundStatement setUUID(int i, UUID v) {
        return (BoundStatement)this.wrapper.setUUID(i, v);
    }

    @Override
    public BoundStatement setUUID(String name, UUID v) {
        return (BoundStatement)this.wrapper.setUUID(name, v);
    }

    @Override
    public BoundStatement setInet(int i, InetAddress v) {
        return (BoundStatement)this.wrapper.setInet(i, v);
    }

    @Override
    public BoundStatement setInet(String name, InetAddress v) {
        return (BoundStatement)this.wrapper.setInet(name, v);
    }

    public BoundStatement setToken(int i, Token v) {
        return (BoundStatement)this.wrapper.setToken(i, v);
    }

    public BoundStatement setToken(String name, Token v) {
        return (BoundStatement)this.wrapper.setToken(name, v);
    }

    public BoundStatement setPartitionKeyToken(Token v) {
        return this.setToken("partition key token", v);
    }

    @Override
    public <T> BoundStatement setList(int i, List<T> v) {
        return (BoundStatement)this.wrapper.setList(i, (List)v);
    }

    @Override
    public <E> BoundStatement setList(int i, List<E> v, Class<E> elementsClass) {
        return (BoundStatement)this.wrapper.setList(i, (List)v, (Class)elementsClass);
    }

    @Override
    public <E> BoundStatement setList(int i, List<E> v, TypeToken<E> elementsType) {
        return (BoundStatement)this.wrapper.setList(i, (List)v, (TypeToken)elementsType);
    }

    @Override
    public <T> BoundStatement setList(String name, List<T> v) {
        return (BoundStatement)this.wrapper.setList(name, v);
    }

    @Override
    public <E> BoundStatement setList(String name, List<E> v, Class<E> elementsClass) {
        return (BoundStatement)this.wrapper.setList(name, v, elementsClass);
    }

    @Override
    public <E> BoundStatement setList(String name, List<E> v, TypeToken<E> elementsType) {
        return (BoundStatement)this.wrapper.setList(name, v, elementsType);
    }

    @Override
    public <K, V> BoundStatement setMap(int i, Map<K, V> v) {
        return (BoundStatement)this.wrapper.setMap(i, (Map)v);
    }

    @Override
    public <K, V> BoundStatement setMap(int i, Map<K, V> v, Class<K> keysClass, Class<V> valuesClass) {
        return (BoundStatement)this.wrapper.setMap(i, (Map)v, (Class)keysClass, (Class)valuesClass);
    }

    @Override
    public <K, V> BoundStatement setMap(int i, Map<K, V> v, TypeToken<K> keysType, TypeToken<V> valuesType) {
        return (BoundStatement)this.wrapper.setMap(i, (Map)v, (TypeToken)keysType, (TypeToken)valuesType);
    }

    @Override
    public <K, V> BoundStatement setMap(String name, Map<K, V> v) {
        return (BoundStatement)this.wrapper.setMap(name, v);
    }

    @Override
    public <K, V> BoundStatement setMap(String name, Map<K, V> v, Class<K> keysClass, Class<V> valuesClass) {
        return (BoundStatement)this.wrapper.setMap(name, v, keysClass, valuesClass);
    }

    @Override
    public <K, V> BoundStatement setMap(String name, Map<K, V> v, TypeToken<K> keysType, TypeToken<V> valuesType) {
        return (BoundStatement)this.wrapper.setMap(name, v, keysType, valuesType);
    }

    @Override
    public <T> BoundStatement setSet(int i, Set<T> v) {
        return (BoundStatement)this.wrapper.setSet(i, (Set)v);
    }

    @Override
    public <E> BoundStatement setSet(int i, Set<E> v, Class<E> elementsClass) {
        return (BoundStatement)this.wrapper.setSet(i, (Set)v, (Class)elementsClass);
    }

    @Override
    public <E> BoundStatement setSet(int i, Set<E> v, TypeToken<E> elementsType) {
        return (BoundStatement)this.wrapper.setSet(i, (Set)v, (TypeToken)elementsType);
    }

    @Override
    public <T> BoundStatement setSet(String name, Set<T> v) {
        return (BoundStatement)this.wrapper.setSet(name, v);
    }

    @Override
    public <E> BoundStatement setSet(String name, Set<E> v, Class<E> elementsClass) {
        return (BoundStatement)this.wrapper.setSet(name, v, elementsClass);
    }

    @Override
    public <E> BoundStatement setSet(String name, Set<E> v, TypeToken<E> elementsType) {
        return (BoundStatement)this.wrapper.setSet(name, v, elementsType);
    }

    @Override
    public BoundStatement setUDTValue(int i, UDTValue v) {
        return (BoundStatement)this.wrapper.setUDTValue(i, v);
    }

    @Override
    public BoundStatement setUDTValue(String name, UDTValue v) {
        return (BoundStatement)this.wrapper.setUDTValue(name, v);
    }

    @Override
    public BoundStatement setTupleValue(int i, TupleValue v) {
        return (BoundStatement)this.wrapper.setTupleValue(i, v);
    }

    @Override
    public BoundStatement setTupleValue(String name, TupleValue v) {
        return (BoundStatement)this.wrapper.setTupleValue(name, v);
    }

    @Override
    public <V> BoundStatement set(int i, V v, Class<V> targetClass) {
        return (BoundStatement)this.wrapper.set(i, (Object)v, (Class)targetClass);
    }

    @Override
    public <V> BoundStatement set(String name, V v, Class<V> targetClass) {
        return (BoundStatement)this.wrapper.set(name, v, targetClass);
    }

    @Override
    public <V> BoundStatement set(int i, V v, TypeToken<V> targetType) {
        return (BoundStatement)this.wrapper.set(i, (Object)v, (TypeToken)targetType);
    }

    @Override
    public <V> BoundStatement set(String name, V v, TypeToken<V> targetType) {
        return (BoundStatement)this.wrapper.set(name, v, targetType);
    }

    @Override
    public <V> BoundStatement set(int i, V v, TypeCodec<V> codec) {
        return (BoundStatement)this.wrapper.set(i, (Object)v, (TypeCodec)codec);
    }

    @Override
    public <V> BoundStatement set(String name, V v, TypeCodec<V> codec) {
        return (BoundStatement)this.wrapper.set(name, v, codec);
    }

    @Override
    public BoundStatement setToNull(int i) {
        return (BoundStatement)this.wrapper.setToNull(i);
    }

    @Override
    public BoundStatement setToNull(String name) {
        return (BoundStatement)this.wrapper.setToNull(name);
    }

    @Override
    public boolean isNull(int i) {
        return this.wrapper.isNull(i);
    }

    @Override
    public boolean isNull(String name) {
        return this.wrapper.isNull(name);
    }

    @Override
    public boolean getBool(int i) {
        return this.wrapper.getBool(i);
    }

    @Override
    public boolean getBool(String name) {
        return this.wrapper.getBool(name);
    }

    @Override
    public byte getByte(int i) {
        return this.wrapper.getByte(i);
    }

    @Override
    public byte getByte(String name) {
        return this.wrapper.getByte(name);
    }

    @Override
    public short getShort(int i) {
        return this.wrapper.getShort(i);
    }

    @Override
    public short getShort(String name) {
        return this.wrapper.getShort(name);
    }

    @Override
    public int getInt(int i) {
        return this.wrapper.getInt(i);
    }

    @Override
    public int getInt(String name) {
        return this.wrapper.getInt(name);
    }

    @Override
    public long getLong(int i) {
        return this.wrapper.getLong(i);
    }

    @Override
    public long getLong(String name) {
        return this.wrapper.getLong(name);
    }

    @Override
    public Date getTimestamp(int i) {
        return this.wrapper.getTimestamp(i);
    }

    @Override
    public Date getTimestamp(String name) {
        return this.wrapper.getTimestamp(name);
    }

    @Override
    public LocalDate getDate(int i) {
        return this.wrapper.getDate(i);
    }

    @Override
    public LocalDate getDate(String name) {
        return this.wrapper.getDate(name);
    }

    @Override
    public long getTime(int i) {
        return this.wrapper.getTime(i);
    }

    @Override
    public long getTime(String name) {
        return this.wrapper.getTime(name);
    }

    @Override
    public float getFloat(int i) {
        return this.wrapper.getFloat(i);
    }

    @Override
    public float getFloat(String name) {
        return this.wrapper.getFloat(name);
    }

    @Override
    public double getDouble(int i) {
        return this.wrapper.getDouble(i);
    }

    @Override
    public double getDouble(String name) {
        return this.wrapper.getDouble(name);
    }

    @Override
    public ByteBuffer getBytesUnsafe(int i) {
        return this.wrapper.getBytesUnsafe(i);
    }

    @Override
    public ByteBuffer getBytesUnsafe(String name) {
        return this.wrapper.getBytesUnsafe(name);
    }

    @Override
    public ByteBuffer getBytes(int i) {
        return this.wrapper.getBytes(i);
    }

    @Override
    public ByteBuffer getBytes(String name) {
        return this.wrapper.getBytes(name);
    }

    @Override
    public String getString(int i) {
        return this.wrapper.getString(i);
    }

    @Override
    public String getString(String name) {
        return this.wrapper.getString(name);
    }

    @Override
    public BigInteger getVarint(int i) {
        return this.wrapper.getVarint(i);
    }

    @Override
    public BigInteger getVarint(String name) {
        return this.wrapper.getVarint(name);
    }

    @Override
    public BigDecimal getDecimal(int i) {
        return this.wrapper.getDecimal(i);
    }

    @Override
    public BigDecimal getDecimal(String name) {
        return this.wrapper.getDecimal(name);
    }

    @Override
    public UUID getUUID(int i) {
        return this.wrapper.getUUID(i);
    }

    @Override
    public UUID getUUID(String name) {
        return this.wrapper.getUUID(name);
    }

    @Override
    public InetAddress getInet(int i) {
        return this.wrapper.getInet(i);
    }

    @Override
    public InetAddress getInet(String name) {
        return this.wrapper.getInet(name);
    }

    @Override
    public <T> List<T> getList(int i, Class<T> elementsClass) {
        return this.wrapper.getList(i, (Class)elementsClass);
    }

    @Override
    public <T> List<T> getList(int i, TypeToken<T> elementsType) {
        return this.wrapper.getList(i, (TypeToken)elementsType);
    }

    @Override
    public <T> List<T> getList(String name, Class<T> elementsClass) {
        return this.wrapper.getList(name, elementsClass);
    }

    @Override
    public <T> List<T> getList(String name, TypeToken<T> elementsType) {
        return this.wrapper.getList(name, elementsType);
    }

    @Override
    public <T> Set<T> getSet(int i, Class<T> elementsClass) {
        return this.wrapper.getSet(i, (Class)elementsClass);
    }

    @Override
    public <T> Set<T> getSet(int i, TypeToken<T> elementsType) {
        return this.wrapper.getSet(i, (TypeToken)elementsType);
    }

    @Override
    public <T> Set<T> getSet(String name, Class<T> elementsClass) {
        return this.wrapper.getSet(name, elementsClass);
    }

    @Override
    public <T> Set<T> getSet(String name, TypeToken<T> elementsType) {
        return this.wrapper.getSet(name, elementsType);
    }

    @Override
    public <K, V> Map<K, V> getMap(int i, Class<K> keysClass, Class<V> valuesClass) {
        return this.wrapper.getMap(i, (Class)keysClass, (Class)valuesClass);
    }

    @Override
    public <K, V> Map<K, V> getMap(int i, TypeToken<K> keysType, TypeToken<V> valuesType) {
        return this.wrapper.getMap(i, (TypeToken)keysType, (TypeToken)valuesType);
    }

    @Override
    public <K, V> Map<K, V> getMap(String name, Class<K> keysClass, Class<V> valuesClass) {
        return this.wrapper.getMap(name, keysClass, valuesClass);
    }

    @Override
    public <K, V> Map<K, V> getMap(String name, TypeToken<K> keysType, TypeToken<V> valuesType) {
        return this.wrapper.getMap(name, keysType, valuesType);
    }

    @Override
    public UDTValue getUDTValue(int i) {
        return this.wrapper.getUDTValue(i);
    }

    @Override
    public UDTValue getUDTValue(String name) {
        return this.wrapper.getUDTValue(name);
    }

    @Override
    public TupleValue getTupleValue(int i) {
        return this.wrapper.getTupleValue(i);
    }

    @Override
    public TupleValue getTupleValue(String name) {
        return this.wrapper.getTupleValue(name);
    }

    @Override
    public Object getObject(int i) {
        return this.wrapper.getObject(i);
    }

    @Override
    public Object getObject(String name) {
        return this.wrapper.getObject(name);
    }

    @Override
    public <T> T get(int i, Class<T> targetClass) {
        return (T)this.wrapper.get(i, (Class)targetClass);
    }

    @Override
    public <T> T get(String name, Class<T> targetClass) {
        return this.wrapper.get(name, targetClass);
    }

    @Override
    public <T> T get(int i, TypeToken<T> targetType) {
        return (T)this.wrapper.get(i, (TypeToken)targetType);
    }

    @Override
    public <T> T get(String name, TypeToken<T> targetType) {
        return this.wrapper.get(name, targetType);
    }

    @Override
    public <T> T get(int i, TypeCodec<T> codec) {
        return (T)this.wrapper.get(i, (TypeCodec)codec);
    }

    @Override
    public <T> T get(String name, TypeCodec<T> codec) {
        return this.wrapper.get(name, codec);
    }

    void ensureAllSet() {
        int index = 0;
        for (ByteBuffer value : this.wrapper.values) {
            if (value == UNSET) {
                throw new IllegalStateException("Unset value at index " + index + ". " + "If you want this value to be null, please set it to null explicitly.");
            }
            ++index;
        }
    }

    static class DataWrapper
    extends AbstractData<BoundStatement> {
        DataWrapper(BoundStatement wrapped, int size) {
            super(wrapped.statement.getPreparedId().protocolVersion, wrapped, size);
        }

        @Override
        protected int[] getAllIndexesOf(String name) {
            return ((BoundStatement)this.wrapped).statement.getVariables().getAllIdx(name);
        }

        @Override
        protected DataType getType(int i) {
            return ((BoundStatement)this.wrapped).statement.getVariables().getType(i);
        }

        @Override
        protected String getName(int i) {
            return ((BoundStatement)this.wrapped).statement.getVariables().getName(i);
        }

        @Override
        protected CodecRegistry getCodecRegistry() {
            return ((BoundStatement)this.wrapped).codecRegistry;
        }
    }
}

