/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.user.privileges;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.client.security.user.privileges.AbstractIndicesPrivileges;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public final class IndicesPrivileges
extends AbstractIndicesPrivileges
implements ToXContentObject {
    static final ConstructingObjectParser<IndicesPrivileges, Void> PARSER = new ConstructingObjectParser("indices_privileges", false, constructorObjects -> {
        int i = 0;
        Collection indices = (Collection)constructorObjects[i++];
        Collection privileges = (Collection)constructorObjects[i++];
        boolean allowRestrictedIndices = (Boolean)constructorObjects[i++];
        AbstractIndicesPrivileges.FieldSecurity fields = (AbstractIndicesPrivileges.FieldSecurity)constructorObjects[i++];
        String query = (String)constructorObjects[i];
        return new IndicesPrivileges(indices, privileges, allowRestrictedIndices, fields, query);
    });
    private final AbstractIndicesPrivileges.FieldSecurity fieldSecurity;
    @Nullable
    private final String query;

    private IndicesPrivileges(Collection<String> indices, Collection<String> privileges, boolean allowRestrictedIndices, @Nullable AbstractIndicesPrivileges.FieldSecurity fieldSecurity, @Nullable String query) {
        super(indices, privileges, allowRestrictedIndices);
        this.fieldSecurity = fieldSecurity;
        this.query = query;
    }

    public AbstractIndicesPrivileges.FieldSecurity getFieldSecurity() {
        return this.fieldSecurity;
    }

    @Nullable
    public String getQuery() {
        return this.query;
    }

    @Override
    public boolean isUsingDocumentLevelSecurity() {
        return this.query != null;
    }

    @Override
    public boolean isUsingFieldLevelSecurity() {
        return this.fieldSecurity != null && this.fieldSecurity.isUsingFieldLevelSecurity();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndicesPrivileges that = (IndicesPrivileges)o;
        return this.indices.equals(that.indices) && this.privileges.equals(that.privileges) && this.allowRestrictedIndices == that.allowRestrictedIndices && Objects.equals(this.fieldSecurity, that.fieldSecurity) && Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(this.indices, this.privileges, this.allowRestrictedIndices, this.fieldSecurity, this.query);
    }

    public String toString() {
        try {
            return XContentHelper.toXContent((ToXContent)this, (XContentType)XContentType.JSON, (boolean)true).utf8ToString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAMES.getPreferredName(), (Iterable)this.indices);
        builder.field(PRIVILEGES.getPreferredName(), (Iterable)this.privileges);
        builder.field(ALLOW_RESTRICTED_INDICES.getPreferredName(), this.allowRestrictedIndices);
        if (this.fieldSecurity != null) {
            builder.field(FIELD_PERMISSIONS.getPreferredName(), (ToXContent)this.fieldSecurity, params);
        }
        if (this.isUsingDocumentLevelSecurity()) {
            builder.field("query", this.query);
        }
        return builder.endObject();
    }

    public static IndicesPrivileges fromXContent(XContentParser parser) {
        return (IndicesPrivileges)PARSER.apply(parser, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), NAMES);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), PRIVILEGES);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ALLOW_RESTRICTED_INDICES);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), AbstractIndicesPrivileges.FieldSecurity::parse, FIELD_PERMISSIONS);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), QUERY);
    }

    public static final class Builder {
        @Nullable
        private Collection<String> indices = null;
        @Nullable
        private Collection<String> privileges = null;
        @Nullable
        private Collection<String> grantedFields = null;
        @Nullable
        private Collection<String> deniedFields = null;
        @Nullable
        private String query = null;
        boolean allowRestrictedIndices = false;

        public Builder indices(String ... indices) {
            return this.indices(Arrays.asList(Objects.requireNonNull(indices, "indices required")));
        }

        public Builder indices(Collection<String> indices) {
            this.indices = Objects.requireNonNull(indices, "indices required");
            return this;
        }

        public Builder privileges(String ... privileges) {
            return this.privileges(Arrays.asList(Objects.requireNonNull(privileges, "privileges required")));
        }

        public Builder privileges(Collection<String> privileges) {
            this.privileges = Objects.requireNonNull(privileges, "privileges required");
            return this;
        }

        public Builder grantedFields(String ... grantedFields) {
            if (grantedFields == null) {
                this.grantedFields = null;
                return this;
            }
            return this.grantedFields(Arrays.asList(grantedFields));
        }

        public Builder grantedFields(@Nullable Collection<String> grantedFields) {
            this.grantedFields = grantedFields;
            return this;
        }

        public Builder deniedFields(String ... deniedFields) {
            if (deniedFields == null) {
                this.deniedFields = null;
                return this;
            }
            return this.deniedFields(Arrays.asList(deniedFields));
        }

        public Builder deniedFields(@Nullable Collection<String> deniedFields) {
            this.deniedFields = deniedFields;
            return this;
        }

        public Builder query(@Nullable String query) {
            this.query = query;
            return this;
        }

        public Builder allowRestrictedIndices(boolean allow) {
            this.allowRestrictedIndices = allow;
            return this;
        }

        public IndicesPrivileges build() {
            AbstractIndicesPrivileges.FieldSecurity fieldSecurity = this.grantedFields == null && this.deniedFields == null ? null : new AbstractIndicesPrivileges.FieldSecurity(this.grantedFields, this.deniedFields);
            return new IndicesPrivileges(this.indices, this.privileges, this.allowRestrictedIndices, fieldSecurity, this.query);
        }
    }
}

