/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.CachePool;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

public class FSPermissionChecker
implements INodeAttributeProvider.AccessControlEnforcer {
    static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private final String fsOwner;
    private final String supergroup;
    private final UserGroupInformation callerUgi;
    private final String user;
    private final Collection<String> groups;
    private final boolean isSuper;
    private final INodeAttributeProvider attributeProvider;

    private static String getPath(byte[][] components, int start, int end) {
        return DFSUtil.byteArray2PathString(components, start, end - start + 1);
    }

    private String toAccessControlString(INodeAttributes inodeAttrib, String path, FsAction access) {
        return this.toAccessControlString(inodeAttrib, path, access, false);
    }

    private String toAccessControlString(INodeAttributes inodeAttrib, String path, FsAction access, boolean deniedFromAcl) {
        StringBuilder sb = new StringBuilder("Permission denied: ").append("user=").append(this.getUser()).append(", ").append("access=").append(access).append(", ").append("inode=\"").append(path).append("\":").append(inodeAttrib.getUserName()).append(':').append(inodeAttrib.getGroupName()).append(':').append(inodeAttrib.isDirectory() ? (char)'d' : '-').append(inodeAttrib.getFsPermission());
        if (deniedFromAcl) {
            sb.append("+");
        }
        return sb.toString();
    }

    protected FSPermissionChecker(String fsOwner, String supergroup, UserGroupInformation callerUgi, INodeAttributeProvider attributeProvider) {
        this.fsOwner = fsOwner;
        this.supergroup = supergroup;
        this.callerUgi = callerUgi;
        this.groups = callerUgi.getGroups();
        this.user = callerUgi.getShortUserName();
        this.isSuper = this.user.equals(fsOwner) || this.groups.contains(supergroup);
        this.attributeProvider = attributeProvider;
    }

    public boolean isMemberOfGroup(String group) {
        return this.groups.contains(group);
    }

    public String getUser() {
        return this.user;
    }

    public boolean isSuperUser() {
        return this.isSuper;
    }

    public INodeAttributeProvider getAttributesProvider() {
        return this.attributeProvider;
    }

    private INodeAttributeProvider.AccessControlEnforcer getAccessControlEnforcer() {
        return this.attributeProvider != null ? this.attributeProvider.getExternalAccessControlEnforcer(this) : this;
    }

    public void checkSuperuserPrivilege() throws AccessControlException {
        if (!this.isSuperUser()) {
            throw new AccessControlException("Access denied for user " + this.getUser() + ". Superuser privilege is required");
        }
    }

    void checkPermission(INodesInPath inodesInPath, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ACCESS CHECK: " + this + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir));
        }
        int snapshotId = inodesInPath.getPathSnapshotId();
        INode[] inodes = inodesInPath.getINodesArray();
        INodeAttributes[] inodeAttrs = new INodeAttributes[inodes.length];
        byte[][] components = inodesInPath.getPathComponents();
        for (int i = 0; i < inodes.length && inodes[i] != null; ++i) {
            inodeAttrs[i] = this.getINodeAttrs(components, i, inodes[i], snapshotId);
        }
        String path = inodesInPath.getPath();
        int ancestorIndex = inodes.length - 2;
        INodeAttributeProvider.AccessControlEnforcer enforcer = this.getAccessControlEnforcer();
        enforcer.checkPermission(this.fsOwner, this.supergroup, this.callerUgi, inodeAttrs, inodes, components, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir);
    }

    void checkPermission(INode inode, int snapshotId, FsAction access) throws AccessControlException {
        try {
            byte[][] localComponents = new byte[][]{inode.getLocalNameBytes()};
            INodeAttributes[] iNodeAttr = new INodeAttributes[]{inode.getSnapshotINode(snapshotId)};
            INodeAttributeProvider.AccessControlEnforcer enforcer = this.getAccessControlEnforcer();
            enforcer.checkPermission(this.fsOwner, this.supergroup, this.callerUgi, iNodeAttr, new INode[]{inode}, localComponents, snapshotId, null, -1, false, null, null, access, null, false);
        }
        catch (AccessControlException ace) {
            throw new AccessControlException(this.toAccessControlString(inode, inode.getFullPathName(), access));
        }
    }

    @Override
    public void checkPermission(String fsOwner, String supergroup, UserGroupInformation callerUgi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] components, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
        while (ancestorIndex >= 0 && inodes[ancestorIndex] == null) {
            --ancestorIndex;
        }
        try {
            this.checkTraverse(inodeAttrs, inodes, components, ancestorIndex);
        }
        catch (ParentNotDirectoryException | UnresolvedPathException ex) {
            throw new TraverseAccessControlException((IOException)ex);
        }
        INodeAttributes last = inodeAttrs[inodeAttrs.length - 1];
        if (parentAccess != null && parentAccess.implies(FsAction.WRITE) && inodeAttrs.length > 1 && last != null) {
            this.checkStickyBit(inodeAttrs, components, inodeAttrs.length - 2);
        }
        if (ancestorAccess != null && inodeAttrs.length > 1) {
            this.check(inodeAttrs, components, ancestorIndex, ancestorAccess);
        }
        if (parentAccess != null && inodeAttrs.length > 1) {
            this.check(inodeAttrs, components, inodeAttrs.length - 2, parentAccess);
        }
        if (access != null) {
            this.check(inodeAttrs, components, inodeAttrs.length - 1, access);
        }
        if (subAccess != null) {
            INode rawLast = inodes[inodeAttrs.length - 1];
            this.checkSubAccess(components, inodeAttrs.length - 1, rawLast, snapshotId, subAccess, ignoreEmptyDir);
        }
        if (doCheckOwner) {
            this.checkOwner(inodeAttrs, components, inodeAttrs.length - 1);
        }
    }

    private INodeAttributes getINodeAttrs(byte[][] pathByNameArr, int pathIdx, INode inode, int snapshotId) {
        INodeAttributes inodeAttrs = inode.getSnapshotINode(snapshotId);
        if (this.getAttributesProvider() != null) {
            String[] elements = new String[pathIdx + 1];
            if (pathByNameArr.length == 1 && pathByNameArr[0] == null) {
                elements[0] = "";
            } else {
                for (int i = 0; i < elements.length; ++i) {
                    elements[i] = DFSUtil.bytes2String(pathByNameArr[i]);
                }
            }
            inodeAttrs = this.getAttributesProvider().getAttributes(elements, inodeAttrs);
        }
        return inodeAttrs;
    }

    private void checkOwner(INodeAttributes[] inodes, byte[][] components, int i) throws AccessControlException {
        if (this.getUser().equals(inodes[i].getUserName())) {
            return;
        }
        throw new AccessControlException("Permission denied. user=" + this.getUser() + " is not the owner of inode=" + FSPermissionChecker.getPath(components, 0, i));
    }

    private void checkTraverse(INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] components, int last) throws AccessControlException, UnresolvedPathException, ParentNotDirectoryException {
        for (int i = 0; i <= last; ++i) {
            FSPermissionChecker.checkIsDirectory(inodes[i], components, i);
            this.check(inodeAttrs, components, i, FsAction.EXECUTE);
        }
    }

    private void checkSubAccess(byte[][] components, int pathIdx, INode inode, int snapshotId, FsAction access, boolean ignoreEmptyDir) throws AccessControlException {
        if (inode == null || !inode.isDirectory()) {
            return;
        }
        ArrayList<INodeDirectory> subINodePath = new ArrayList<INodeDirectory>();
        Stack<Integer> levels = new Stack<Integer>();
        levels.push(0);
        Stack<INodeDirectory> directories = new Stack<INodeDirectory>();
        directories.push(inode.asDirectory());
        while (!directories.isEmpty()) {
            INodeDirectory d = (INodeDirectory)directories.pop();
            int level = (Integer)levels.pop();
            ReadOnlyList<INode> cList = d.getChildrenList(snapshotId);
            if (!cList.isEmpty() || !ignoreEmptyDir) {
                INodeAttributes inodeAttr = this.getINodeAttrs(components, pathIdx, d, snapshotId);
                if (!this.hasPermission(inodeAttr, access)) {
                    throw new AccessControlException(this.toAccessControlString(inodeAttr, d.getFullPathName(), access));
                }
                if (level > 0) {
                    if (level - 1 < subINodePath.size()) {
                        subINodePath.set(level - 1, d);
                    } else {
                        Preconditions.checkState((level - 1 == subINodePath.size() ? 1 : 0) != 0);
                        subINodePath.add(d);
                    }
                }
                if (inodeAttr.getFsPermission().getStickyBit()) {
                    for (INode child : cList) {
                        int i;
                        INodeAttributes childInodeAttr = this.getINodeAttrs(components, pathIdx, child, snapshotId);
                        if (!this.isStickyBitViolated(inodeAttr, childInodeAttr)) continue;
                        ArrayList<byte[]> allComponentList = new ArrayList<byte[]>();
                        for (i = 0; i <= pathIdx; ++i) {
                            allComponentList.add(components[i]);
                        }
                        for (i = 0; i < level; ++i) {
                            allComponentList.add(((INodeDirectory)subINodePath.get(i)).getLocalNameBytes());
                        }
                        allComponentList.add(child.getLocalNameBytes());
                        int index = pathIdx + level;
                        byte[][] allComponents = (byte[][])allComponentList.toArray((T[])new byte[0][]);
                        this.throwStickyBitException(FSPermissionChecker.getPath(allComponents, 0, index + 1), child, FSPermissionChecker.getPath(allComponents, 0, index), inode);
                    }
                }
            }
            for (INode child : cList) {
                if (!child.isDirectory()) continue;
                directories.push(child.asDirectory());
                levels.push(level + 1);
            }
        }
    }

    private void check(INodeAttributes[] inodes, byte[][] components, int i, FsAction access) throws AccessControlException {
        INodeAttributes inode;
        INodeAttributes iNodeAttributes = inode = i >= 0 ? inodes[i] : null;
        if (inode != null && !this.hasPermission(inode, access)) {
            throw new AccessControlException(this.toAccessControlString(inode, FSPermissionChecker.getPath(components, 0, i), access));
        }
    }

    private boolean hasPermission(INodeAttributes inode, FsAction access) {
        int firstEntry;
        if (inode == null) {
            return true;
        }
        FsPermission mode = inode.getFsPermission();
        AclFeature aclFeature = inode.getAclFeature();
        if (aclFeature != null && aclFeature.getEntriesSize() > 0 && AclEntryStatusFormat.getScope(firstEntry = aclFeature.getEntryAt(0)) == AclEntryScope.ACCESS) {
            return this.hasAclPermission(inode, access, mode, aclFeature);
        }
        FsAction checkAction = this.getUser().equals(inode.getUserName()) ? mode.getUserAction() : (this.isMemberOfGroup(inode.getGroupName()) ? mode.getGroupAction() : mode.getOtherAction());
        return checkAction.implies(access);
    }

    private boolean hasAclPermission(INodeAttributes inode, FsAction access, FsPermission mode, AclFeature aclFeature) {
        boolean foundMatch = false;
        if (this.getUser().equals(inode.getUserName())) {
            if (mode.getUserAction().implies(access)) {
                return true;
            }
            foundMatch = true;
        }
        if (!foundMatch) {
            int entry;
            for (int pos = 0; pos < aclFeature.getEntriesSize() && AclEntryStatusFormat.getScope(entry = aclFeature.getEntryAt(pos)) != AclEntryScope.DEFAULT; ++pos) {
                String group;
                AclEntryType type = AclEntryStatusFormat.getType(entry);
                String name = AclEntryStatusFormat.getName(entry);
                if (type == AclEntryType.USER) {
                    if (!this.getUser().equals(name)) continue;
                    FsAction masked = AclEntryStatusFormat.getPermission(entry).and(mode.getGroupAction());
                    if (masked.implies(access)) {
                        return true;
                    }
                    foundMatch = true;
                    break;
                }
                if (type != AclEntryType.GROUP) continue;
                String string = group = name == null ? inode.getGroupName() : name;
                if (!this.isMemberOfGroup(group)) continue;
                FsAction masked = AclEntryStatusFormat.getPermission(entry).and(mode.getGroupAction());
                if (masked.implies(access)) {
                    return true;
                }
                foundMatch = true;
            }
        }
        return !foundMatch && mode.getOtherAction().implies(access);
    }

    private void checkStickyBit(INodeAttributes[] inodes, byte[][] components, int index) throws AccessControlException {
        INodeAttributes parent = inodes[index];
        if (!parent.getFsPermission().getStickyBit()) {
            return;
        }
        INodeAttributes inode = inodes[index + 1];
        if (!this.isStickyBitViolated(parent, inode)) {
            return;
        }
        this.throwStickyBitException(FSPermissionChecker.getPath(components, 0, index + 1), inode, FSPermissionChecker.getPath(components, 0, index), parent);
    }

    private boolean isStickyBitViolated(INodeAttributes parent, INodeAttributes inode) {
        if (parent.getUserName().equals(this.getUser())) {
            return false;
        }
        return !inode.getUserName().equals(this.getUser());
    }

    private void throwStickyBitException(String inodePath, INodeAttributes inode, String parentPath, INodeAttributes parent) throws AccessControlException {
        throw new AccessControlException(String.format("Permission denied by sticky bit: user=%s, path=\"%s\":%s:%s:%s%s, parent=\"%s\":%s:%s:%s%s", this.user, inodePath, inode.getUserName(), inode.getGroupName(), inode.isDirectory() ? "d" : "-", inode.getFsPermission().toString(), parentPath, parent.getUserName(), parent.getGroupName(), parent.isDirectory() ? "d" : "-", parent.getFsPermission().toString()));
    }

    public void checkPermission(CachePool pool, FsAction access) throws AccessControlException {
        FsPermission mode = pool.getMode();
        if (this.isSuperUser()) {
            return;
        }
        if (this.getUser().equals(pool.getOwnerName()) && mode.getUserAction().implies(access)) {
            return;
        }
        if (this.isMemberOfGroup(pool.getGroupName()) && mode.getGroupAction().implies(access)) {
            return;
        }
        if (!this.getUser().equals(pool.getOwnerName()) && !this.isMemberOfGroup(pool.getGroupName()) && mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException("Permission denied while accessing pool " + pool.getPoolName() + ": user " + this.getUser() + " does not have " + access.toString() + " permissions.");
    }

    static void checkTraverse(FSPermissionChecker pc, INodesInPath iip, boolean resolveLink) throws AccessControlException, UnresolvedPathException, ParentNotDirectoryException {
        try {
            if (pc == null || pc.isSuperUser()) {
                FSPermissionChecker.checkSimpleTraverse(iip);
            } else {
                pc.checkPermission(iip, false, null, null, null, null, false);
            }
        }
        catch (TraverseAccessControlException tace) {
            tace.throwCause();
        }
        if (resolveLink) {
            int last = iip.length() - 1;
            FSPermissionChecker.checkNotSymlink(iip.getINode(last), iip.getPathComponents(), last);
        }
    }

    private static void checkSimpleTraverse(INodesInPath iip) throws UnresolvedPathException, ParentNotDirectoryException {
        INode inode;
        byte[][] components = iip.getPathComponents();
        for (int i = 0; i < iip.length() - 1 && (inode = iip.getINode(i)) != null; ++i) {
            FSPermissionChecker.checkIsDirectory(inode, components, i);
        }
    }

    private static void checkIsDirectory(INode inode, byte[][] components, int i) throws UnresolvedPathException, ParentNotDirectoryException {
        if (inode != null && !inode.isDirectory()) {
            FSPermissionChecker.checkNotSymlink(inode, components, i);
            throw new ParentNotDirectoryException(FSPermissionChecker.getPath(components, 0, i) + " (is not a directory)");
        }
    }

    private static void checkNotSymlink(INode inode, byte[][] components, int i) throws UnresolvedPathException {
        if (inode != null && inode.isSymlink()) {
            int last = components.length - 1;
            String path = FSPermissionChecker.getPath(components, 0, last);
            String preceding = FSPermissionChecker.getPath(components, 0, i - 1);
            String remainder = FSPermissionChecker.getPath(components, i + 1, last);
            String target = inode.asSymlink().getSymlinkString();
            if (LOG.isDebugEnabled()) {
                String link = inode.getLocalName();
                LOG.debug((Object)("UnresolvedPathException  path: " + path + " preceding: " + preceding + " count: " + i + " link: " + link + " target: " + target + " remainder: " + remainder));
            }
            throw new UnresolvedPathException(path, preceding, remainder, target);
        }
    }

    static class TraverseAccessControlException
    extends AccessControlException {
        TraverseAccessControlException(IOException ioe) {
            super((Throwable)ioe);
        }

        public void throwCause() throws UnresolvedPathException, ParentNotDirectoryException, AccessControlException {
            Throwable ioe = this.getCause();
            if (ioe instanceof UnresolvedPathException) {
                throw (UnresolvedPathException)ioe;
            }
            if (ioe instanceof ParentNotDirectoryException) {
                throw (ParentNotDirectoryException)ioe;
            }
            throw this;
        }
    }
}

