/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.core.JanusGraphException;

public class ResourceUnavailableException
extends JanusGraphException {
    private static final long serialVersionUID = 482890657293484420L;

    public ResourceUnavailableException(String msg) {
        super(msg);
    }

    public ResourceUnavailableException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public ResourceUnavailableException(Throwable cause) {
        this("Attempting to access unavailable resource", cause);
    }

    public static void verifyOpen(boolean isOpen, String resourceName, String ... resourceIdentifiers) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)resourceName));
        if (!isOpen) {
            StringBuilder msg = new StringBuilder();
            msg.append(resourceName).append(" ");
            if (resourceIdentifiers != null && resourceIdentifiers.length > 0) {
                msg.append("[");
                for (int i = 0; i < resourceIdentifiers.length; ++i) {
                    if (i > 0) {
                        msg.append(",");
                    }
                    msg.append(resourceIdentifiers[i]);
                }
                msg.append("] ");
            }
            msg.append("has been closed");
            throw new ResourceUnavailableException(msg.toString());
        }
    }
}

