/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.management;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexField;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;

public class JanusGraphIndexWrapper
implements JanusGraphIndex {
    private final IndexType index;

    public JanusGraphIndexWrapper(IndexType index) {
        this.index = index;
    }

    IndexType getBaseIndex() {
        return this.index;
    }

    @Override
    public String name() {
        return this.index.getName();
    }

    @Override
    public String getBackingIndex() {
        return this.index.getBackingIndexName();
    }

    @Override
    public Class<? extends Element> getIndexedElement() {
        return this.index.getElement().getElementType();
    }

    @Override
    public PropertyKey[] getFieldKeys() {
        IndexField[] fields = this.index.getFieldKeys();
        PropertyKey[] keys = new PropertyKey[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            keys[i] = fields[i].getFieldKey();
        }
        return keys;
    }

    @Override
    public Parameter[] getParametersFor(PropertyKey key) {
        if (this.index.isCompositeIndex()) {
            return new Parameter[0];
        }
        return ((MixedIndexType)this.index).getField(key).getParameters();
    }

    @Override
    public boolean isUnique() {
        return !this.index.isMixedIndex() && ((CompositeIndexType)this.index).getCardinality() == Cardinality.SINGLE;
    }

    @Override
    public SchemaStatus getIndexStatus(PropertyKey key) {
        Preconditions.checkArgument((boolean)Sets.newHashSet((Object[])this.getFieldKeys()).contains(key), (String)"Provided key is not part of this index: %s", (Object[])new Object[]{key});
        if (this.index.isCompositeIndex()) {
            return ((CompositeIndexType)this.index).getStatus();
        }
        return ((MixedIndexType)this.index).getField(key).getStatus();
    }

    @Override
    public boolean isCompositeIndex() {
        return this.index.isCompositeIndex();
    }

    @Override
    public boolean isMixedIndex() {
        return this.index.isMixedIndex();
    }

    public String toString() {
        return this.name();
    }
}

