/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.lang.reflect.Array;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.attribute.ArraySerializer;

public class ByteArraySerializer
extends ArraySerializer
implements AttributeSerializer<byte[]> {
    @Override
    public byte[] convert(Object value) {
        return (byte[])this.convertInternal(value, Byte.TYPE, Byte.class);
    }

    @Override
    protected Object getArray(int length) {
        return new byte[length];
    }

    @Override
    protected void setArray(Object array, int pos, Object value) {
        Array.setByte(array, pos, (Byte)value);
    }

    @Override
    public byte[] read(ScanBuffer buffer) {
        int length = this.getLength(buffer);
        if (length < 0) {
            return null;
        }
        return buffer.getBytes(length);
    }

    @Override
    public void write(WriteBuffer buffer, byte[] attribute) {
        this.writeLength(buffer, attribute);
        if (attribute != null) {
            for (byte anAttribute : attribute) {
                buffer.putByte(anAttribute);
            }
        }
    }
}

