/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.olap.QueryContainer;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.graphdb.relations.RelationCache;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.transaction.StandardTransactionBuilder;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.vertices.PreloadedVertex;

public class VertexJobConverter
implements ScanJob {
    protected static final SliceQuery VERTEX_EXISTS_QUERY = new SliceQuery(BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(4)).setLimit(1);
    public static final String GHOST_VERTEX_COUNT = "ghost-vertices";
    public static final String TRUNCATED_ENTRY_LISTS = "truncated-results";
    protected final GraphProvider graph;
    protected final VertexScanJob job;
    protected StandardJanusGraphTx tx;
    private IDManager idManager;

    protected VertexJobConverter(JanusGraph graph, VertexScanJob job) {
        Preconditions.checkArgument((job != null ? 1 : 0) != 0);
        this.graph = new GraphProvider();
        if (graph != null) {
            this.graph.setGraph(graph);
        }
        this.job = job;
    }

    protected VertexJobConverter(VertexJobConverter copy) {
        this.graph = copy.graph;
        this.job = copy.job.clone();
        this.tx = copy.tx;
        this.idManager = copy.idManager;
    }

    public static ScanJob convert(JanusGraph graph, VertexScanJob vertexJob) {
        return new VertexJobConverter(graph, vertexJob);
    }

    public static ScanJob convert(VertexScanJob vertexJob) {
        return new VertexJobConverter(null, vertexJob);
    }

    public static StandardJanusGraphTx startTransaction(StandardJanusGraph graph) {
        StandardTransactionBuilder txb = graph.buildTransaction().readOnly();
        txb.setPreloadedData(true);
        txb.checkInternalVertexExistence(false);
        txb.dirtyVertexSize(0);
        txb.vertexCacheSize(0);
        return (StandardJanusGraphTx)txb.start();
    }

    @Override
    public void workerIterationStart(Configuration jobConfig, Configuration graphConfig, ScanMetrics metrics) {
        try {
            this.open(graphConfig);
            this.job.workerIterationStart(this.graph.get(), jobConfig, metrics);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    protected void open(Configuration graphConfig) {
        this.graph.initializeGraph(graphConfig);
        this.idManager = this.graph.get().getIDManager();
        this.tx = VertexJobConverter.startTransaction(this.graph.get());
    }

    protected void close() {
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.rollback();
        }
        this.graph.close();
    }

    @Override
    public void workerIterationEnd(ScanMetrics metrics) {
        this.job.workerIterationEnd(metrics);
        this.close();
    }

    @Override
    public void process(StaticBuffer key, Map<SliceQuery, EntryList> entries, ScanMetrics metrics) {
        long vertexId = this.getVertexId(key);
        assert (entries.get(VERTEX_EXISTS_QUERY) != null);
        if (this.isGhostVertex(vertexId, entries.get(VERTEX_EXISTS_QUERY))) {
            metrics.incrementCustom(GHOST_VERTEX_COUNT);
            return;
        }
        InternalVertex vertex = this.tx.getInternalVertex(vertexId);
        Preconditions.checkArgument((boolean)(vertex instanceof PreloadedVertex), (Object)"The bounding transaction is not configured correctly");
        PreloadedVertex v = (PreloadedVertex)vertex;
        v.setAccessCheck(PreloadedVertex.OPENSTAR_CHECK);
        for (Map.Entry<SliceQuery, EntryList> entry : entries.entrySet()) {
            SliceQuery sq = entry.getKey();
            if (sq.equals(VERTEX_EXISTS_QUERY)) continue;
            EntryList entryList = entry.getValue();
            if (entryList.size() >= sq.getLimit()) {
                metrics.incrementCustom(TRUNCATED_ENTRY_LISTS);
            }
            v.addToQueryCache(sq.updateLimit(Integer.MAX_VALUE), entryList);
        }
        this.job.process(v, metrics);
    }

    protected boolean isGhostVertex(long vertexId, EntryList firstEntries) {
        if (this.idManager.isPartitionedVertex(vertexId) && !this.idManager.isCanonicalVertexId(vertexId)) {
            return false;
        }
        RelationCache relCache = this.tx.getEdgeSerializer().parseRelation((Entry)firstEntries.get(0), true, this.tx);
        return relCache.typeId != BaseKey.VertexExists.longId();
    }

    @Override
    public List<SliceQuery> getQueries() {
        try {
            QueryContainer qc = new QueryContainer(this.tx);
            this.job.getQueries(qc);
            ArrayList<SliceQuery> slices = new ArrayList<SliceQuery>();
            slices.add(VERTEX_EXISTS_QUERY);
            slices.addAll(qc.getSliceQueries());
            return slices;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public Predicate<StaticBuffer> getKeyFilter() {
        return buffer -> !IDManager.VertexIDType.Invisible.is(this.getVertexId((StaticBuffer)buffer));
    }

    @Override
    public VertexJobConverter clone() {
        return new VertexJobConverter(this);
    }

    protected long getVertexId(StaticBuffer key) {
        return this.idManager.getKeyID(key);
    }

    public static class GraphProvider {
        private StandardJanusGraph graph = null;
        private boolean provided = false;

        public void setGraph(JanusGraph graph) {
            Preconditions.checkArgument((graph != null && graph.isOpen() ? 1 : 0) != 0, (Object)"Need to provide open graph");
            this.graph = (StandardJanusGraph)graph;
            this.provided = true;
        }

        public void initializeGraph(Configuration config) {
            if (!this.provided) {
                this.graph = (StandardJanusGraph)JanusGraphFactory.open((BasicConfiguration)config);
            }
        }

        public void close() {
            if (!this.provided && null != this.graph && this.graph.isOpen()) {
                this.graph.close();
                this.graph = null;
            }
        }

        public boolean isProvided() {
            return this.provided;
        }

        public final StandardJanusGraph get() {
            Preconditions.checkNotNull((Object)this.graph);
            return this.graph;
        }
    }
}

