/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types.vertices;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.Connection;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.types.vertices.RelationTypeVertex;

public class EdgeLabelVertex
extends RelationTypeVertex
implements EdgeLabel {
    public EdgeLabelVertex(StandardJanusGraphTx tx, long id, byte lifecycle) {
        super(tx, id, lifecycle);
    }

    @Override
    public boolean isDirected() {
        return this.isUnidirected(Direction.BOTH);
    }

    @Override
    public boolean isUnidirected() {
        return this.isUnidirected(Direction.OUT);
    }

    @Override
    public Collection<PropertyKey> mappedProperties() {
        return StreamSupport.stream(this.getRelated(TypeDefinitionCategory.PROPERTY_KEY_EDGE, Direction.OUT).spliterator(), false).map(entry -> (PropertyKey)((Object)entry.getSchemaType())).collect(Collectors.toList());
    }

    @Override
    public Collection<Connection> mappedConnections() {
        String name = this.name();
        return StreamSupport.stream(this.getRelated(TypeDefinitionCategory.UPDATE_CONNECTION_EDGE, Direction.OUT).spliterator(), false).map(entry -> (JanusGraphSchemaVertex)entry.getSchemaType()).flatMap(s -> StreamSupport.stream(s.getEdges(TypeDefinitionCategory.CONNECTION_EDGE, Direction.OUT).spliterator(), false)).map(Connection::new).filter(s -> s.getEdgeLabel().equals(name)).collect(Collectors.toList());
    }

    @Override
    public boolean isUnidirected(Direction dir) {
        return this.getDefinition().getValue(TypeDefinitionCategory.UNIDIRECTIONAL, Direction.class) == dir;
    }

    @Override
    public final boolean isPropertyKey() {
        return false;
    }

    @Override
    public final boolean isEdgeLabel() {
        return true;
    }
}

