/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.PreInitializeConfigOptions;

@PreInitializeConfigOptions
public interface CQLConfigOptions {
    public static final ConfigNamespace CQL_NS = new ConfigNamespace(GraphDatabaseConfiguration.STORAGE_NS, "cql", "CQL storage backend options");
    public static final ConfigOption<String> KEYSPACE = new ConfigOption(CQL_NS, "keyspace", "The name of JanusGraph's keyspace.  It will be created if it does not exist.", ConfigOption.Type.LOCAL, (Object)"janusgraph");
    public static final ConfigOption<Integer> PROTOCOL_VERSION = new ConfigOption(CQL_NS, "protocol-version", "The protocol version used to connect to the Cassandra database.  If no value is supplied then the driver will negotiate with the server.", ConfigOption.Type.LOCAL, (Object)0);
    public static final ConfigOption<String> READ_CONSISTENCY = new ConfigOption(CQL_NS, "read-consistency-level", "The consistency level of read operations against Cassandra", ConfigOption.Type.MASKABLE, (Object)"QUORUM");
    public static final ConfigOption<String> WRITE_CONSISTENCY = new ConfigOption(CQL_NS, "write-consistency-level", "The consistency level of write operations against Cassandra", ConfigOption.Type.MASKABLE, (Object)"QUORUM");
    public static final ConfigOption<Boolean> ONLY_USE_LOCAL_CONSISTENCY_FOR_SYSTEM_OPERATIONS = new ConfigOption(CQL_NS, "only-use-local-consistency-for-system-operations", "True to prevent any system queries from using QUORUM consistency and always use LOCAL_QUORUM instead", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<Boolean> USE_EXTERNAL_LOCKING = new ConfigOption(CQL_NS, "use-external-locking", "True to prevent JanusGraph from using its own locking mechanism. Setting this to true eliminates redundant checks when using an external locking mechanism outside of JanusGraph. Be aware that when use-external-locking is set to true, that failure to employ a locking algorithm which locks all columns that participate in a transaction upfront and unlocks them when the transaction ends, will result in a 'read uncommitted' transaction isolation level guarantee. If set to true without an appropriate external locking mechanism in place side effects such as dirty/non-repeatable/phantom reads should be expected.", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<Integer> BATCH_STATEMENT_SIZE = new ConfigOption(CQL_NS, "batch-statement-size", "The number of statements in each batch", ConfigOption.Type.MASKABLE, (Object)20);
    public static final ConfigOption<Boolean> ATOMIC_BATCH_MUTATE = new ConfigOption(CQL_NS, "atomic-batch-mutate", "True to use Cassandra atomic batch mutation, false to use non-atomic batches", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<Integer> REPLICATION_FACTOR = new ConfigOption(CQL_NS, "replication-factor", "The number of data replicas (including the original copy) that should be kept", ConfigOption.Type.GLOBAL_OFFLINE, (Object)1);
    public static final ConfigOption<String> REPLICATION_STRATEGY = new ConfigOption(CQL_NS, "replication-strategy-class", "The replication strategy to use for JanusGraph keyspace", ConfigOption.Type.FIXED, (Object)"SimpleStrategy");
    public static final ConfigOption<String[]> REPLICATION_OPTIONS = new ConfigOption(CQL_NS, "replication-strategy-options", "Replication strategy options, e.g. factor or replicas per datacenter.  This list is interpreted as a map.  It must have an even number of elements in [key,val,key,val,...] form.  A replication_factor set here takes precedence over one set with " + ConfigElement.getPath(REPLICATION_FACTOR, (String[])new String[0]), ConfigOption.Type.FIXED, String[].class);
    public static final ConfigOption<String> COMPACTION_STRATEGY = new ConfigOption(CQL_NS, "compaction-strategy-class", "The compaction strategy to use for JanusGraph tables", ConfigOption.Type.FIXED, String.class);
    public static final ConfigOption<String[]> COMPACTION_OPTIONS = new ConfigOption(CQL_NS, "compaction-strategy-options", "Compaction strategy options.  This list is interpreted as a map.  It must have an even number of elements in [key,val,key,val,...] form.", ConfigOption.Type.FIXED, String[].class);
    public static final ConfigOption<Boolean> CF_COMPACT_STORAGE = new ConfigOption(CQL_NS, "compact-storage", "Whether the storage backend should use compact storage on tables. This option is only available for Cassandra 2 and earlier and defaults to true.", ConfigOption.Type.FIXED, Boolean.class, (Object)true);
    public static final ConfigOption<Boolean> CF_COMPRESSION = new ConfigOption(CQL_NS, "compression", "Whether the storage backend should use compression when storing the data", ConfigOption.Type.FIXED, (Object)true);
    public static final ConfigOption<String> CF_COMPRESSION_TYPE = new ConfigOption(CQL_NS, "compression-type", "The sstable_compression value JanusGraph uses when creating column families. This accepts any value allowed by Cassandra's sstable_compression option. Leave this unset to disable sstable_compression on JanusGraph-created CFs.", ConfigOption.Type.MASKABLE, (Object)"LZ4Compressor");
    public static final ConfigOption<Integer> CF_COMPRESSION_BLOCK_SIZE = new ConfigOption(CQL_NS, "compression-block-size", "The size of the compression blocks in kilobytes", ConfigOption.Type.FIXED, (Object)64);
    public static final ConfigOption<Integer> LOCAL_CORE_CONNECTIONS_PER_HOST = new ConfigOption(CQL_NS, "local-core-connections-per-host", "The number of connections initially created and kept open to each host for local datacenter", ConfigOption.Type.FIXED, (Object)1);
    public static final ConfigOption<Integer> REMOTE_CORE_CONNECTIONS_PER_HOST = new ConfigOption(CQL_NS, "remote-core-connections-per-host", "The number of connections initially created and kept open to each host for remote datacenter", ConfigOption.Type.FIXED, (Object)1);
    public static final ConfigOption<Integer> LOCAL_MAX_CONNECTIONS_PER_HOST = new ConfigOption(CQL_NS, "local-max-connections-per-host", "The maximum number of connections that can be created per host for local datacenter", ConfigOption.Type.FIXED, (Object)1);
    public static final ConfigOption<Integer> REMOTE_MAX_CONNECTIONS_PER_HOST = new ConfigOption(CQL_NS, "remote-max-connections-per-host", "The maximum number of connections that can be created per host for remote datacenter", ConfigOption.Type.FIXED, (Object)1);
    public static final ConfigOption<Integer> LOCAL_MAX_REQUESTS_PER_CONNECTION = new ConfigOption(CQL_NS, "local-max-requests-per-connection", "The maximum number of requests per connection for local datacenter", ConfigOption.Type.FIXED, (Object)1024);
    public static final ConfigOption<Integer> REMOTE_MAX_REQUESTS_PER_CONNECTION = new ConfigOption(CQL_NS, "remote-max-requests-per-connection", "The maximum number of requests per connection for remote datacenter", ConfigOption.Type.FIXED, (Object)256);
    public static final ConfigNamespace SSL_NS = new ConfigNamespace(CQL_NS, "ssl", "Configuration options for SSL");
    public static final ConfigNamespace SSL_KEYSTORE_NS = new ConfigNamespace(SSL_NS, "keystore", "Configuration options for SSL Keystore.");
    public static final ConfigNamespace SSL_TRUSTSTORE_NS = new ConfigNamespace(SSL_NS, "truststore", "Configuration options for SSL Truststore.");
    public static final ConfigOption<Boolean> SSL_CLIENT_AUTHENTICATION_ENABLED = new ConfigOption(SSL_NS, "client-authentication-enabled", "Enables use of a client key to authenticate with Cassandra", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<Boolean> SSL_ENABLED = new ConfigOption(SSL_NS, "enabled", "Controls use of the SSL connection to Cassandra", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<String> SSL_KEYSTORE_LOCATION = new ConfigOption(SSL_KEYSTORE_NS, "location", "Marks the location of the SSL Keystore.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigOption<String> SSL_KEYSTORE_KEY_PASSWORD = new ConfigOption(SSL_KEYSTORE_NS, "keypassword", "The password to access the key in SSL Keystore.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigOption<String> SSL_KEYSTORE_STORE_PASSWORD = new ConfigOption(SSL_KEYSTORE_NS, "storepassword", "The password to access the SSL Keystore.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigOption<String> SSL_TRUSTSTORE_LOCATION = new ConfigOption(SSL_TRUSTSTORE_NS, "location", "Marks the location of the SSL Truststore.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigOption<String> SSL_TRUSTSTORE_PASSWORD = new ConfigOption(SSL_TRUSTSTORE_NS, "password", "The password to access SSL Truststore.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigOption<String> CLUSTER_NAME = new ConfigOption(CQL_NS, "cluster-name", "Default name for the Cassandra cluster", ConfigOption.Type.MASKABLE, (Object)"JanusGraph Cluster");
    public static final ConfigOption<String> LOCAL_DATACENTER = new ConfigOption(CQL_NS, "local-datacenter", "The name of the local or closest Cassandra datacenter.  When set and not whitespace, this value will be passed into ConnectionPoolConfigurationImpl.setLocalDatacenter. When unset or set to whitespace, setLocalDatacenter will not be invoked.", ConfigOption.Type.MASKABLE, String.class);
}

