/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.apache.tinkerpop.gremlin.process.traversal.util.OrP;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanusGraphPSerializer
extends Serializer<P> {
    private static final Logger log = LoggerFactory.getLogger(JanusGraphPSerializer.class);

    public void write(Kryo kryo, Output output, P p) {
        output.writeString(p instanceof ConnectiveP ? (p instanceof AndP ? "and" : "or") : p.getBiPredicate().toString());
        if (p instanceof ConnectiveP || p.getValue() instanceof Collection) {
            output.writeByte((byte)0);
            Collection coll = p instanceof ConnectiveP ? ((ConnectiveP)p).getPredicates() : (Collection)p.getValue();
            output.writeInt(coll.size());
            coll.forEach(v -> kryo.writeClassAndObject(output, v));
        } else {
            output.writeByte((byte)1);
            kryo.writeClassAndObject(output, p.getValue());
        }
    }

    public P read(Kryo kryo, Input input, Class<P> aClass) {
        Object value;
        boolean isCollection;
        String predicate = input.readString();
        boolean bl = isCollection = input.readByte() == 0;
        if (isCollection) {
            value = new ArrayList();
            int size = input.readInt();
            for (int ix = 0; ix < size; ++ix) {
                ((List)value).add(kryo.readClassAndObject(input));
            }
        } else {
            value = kryo.readClassAndObject(input);
        }
        try {
            return JanusGraphPSerializer.createPredicateWithValue(predicate, value);
        }
        catch (Exception e) {
            log.info("Couldn't deserialize class: " + aClass + ", predicate: " + predicate + ", isCollection: " + isCollection + ",value: " + value, (Throwable)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static P createPredicateWithValue(String predicate, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (value instanceof Collection) {
            switch (predicate) {
                case "and": {
                    return new AndP((List)value);
                }
                case "or": {
                    return new OrP((List)value);
                }
                case "between": {
                    return P.between(((List)value).get(0), ((List)value).get(1));
                }
                case "inside": {
                    return P.inside(((List)value).get(0), ((List)value).get(1));
                }
                case "outside": {
                    return P.outside(((List)value).get(0), ((List)value).get(1));
                }
                case "within": {
                    return P.within((Collection)((Collection)value));
                }
                case "without": {
                    return P.without((Collection)((Collection)value));
                }
            }
            return (P)P.class.getMethod(predicate, Collection.class).invoke(null, value);
        }
        switch (predicate) {
            case "geoIntersect": {
                return Geo.geoIntersect(value);
            }
            case "geoDisjoint": {
                return Geo.geoDisjoint(value);
            }
            case "geoWithin": {
                return Geo.geoWithin(value);
            }
            case "geoContains": {
                return Geo.geoContains(value);
            }
            case "textContains": {
                return Text.textContains(value);
            }
            case "textContainsFuzzy": {
                return Text.textContainsFuzzy(value);
            }
            case "textContainsPrefix": {
                return Text.textContainsPrefix(value);
            }
            case "textContainsRegex": {
                return Text.textContainsRegex(value);
            }
            case "textFuzzy": {
                return Text.textFuzzy(value);
            }
            case "textPrefix": {
                return Text.textPrefix(value);
            }
            case "textRegex": {
                return Text.textRegex(value);
            }
        }
        return (P)P.class.getMethod(predicate, Object.class).invoke(null, value);
    }
}

