/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.PagingState;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBCodec;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBUtil;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;

public class QueryOptions {
    public static final QueryOptions DEFAULT = new QueryOptions(ConsistencyLevel.ONE, Collections.emptyList());
    public static final CBCodec<QueryOptions> codec = new Codec();
    private final ConsistencyLevel consistency;
    private final List<ByteBuffer> values;
    private final boolean skipMetadata;
    private final SpecificOptions options;
    private final transient int protocolVersion;

    public QueryOptions(ConsistencyLevel consistency, List<ByteBuffer> values) {
        this(consistency, values, false, SpecificOptions.DEFAULT, 0);
    }

    public QueryOptions(ConsistencyLevel consistency, List<ByteBuffer> values, boolean skipMetadata, int pageSize, PagingState pagingState, ConsistencyLevel serialConsistency) {
        this(consistency, values, skipMetadata, new SpecificOptions(pageSize, pagingState, serialConsistency), 0);
    }

    private QueryOptions(ConsistencyLevel consistency, List<ByteBuffer> values, boolean skipMetadata, SpecificOptions options, int protocolVersion) {
        this.consistency = consistency;
        this.values = values;
        this.skipMetadata = skipMetadata;
        this.options = options;
        this.protocolVersion = protocolVersion;
    }

    public static QueryOptions fromProtocolV1(ConsistencyLevel consistency, List<ByteBuffer> values) {
        return new QueryOptions(consistency, values, false, SpecificOptions.DEFAULT, 1);
    }

    public ConsistencyLevel getConsistency() {
        return this.consistency;
    }

    public List<ByteBuffer> getValues() {
        return this.values;
    }

    public boolean skipMetadata() {
        return this.skipMetadata;
    }

    public int getPageSize() {
        return this.options.pageSize;
    }

    public PagingState getPagingState() {
        return this.options.state;
    }

    public ConsistencyLevel getSerialConsistency() {
        return this.options.serialConsistency;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    private static class Codec
    implements CBCodec<QueryOptions> {
        private Codec() {
        }

        @Override
        public QueryOptions decode(ChannelBuffer body, int version) {
            assert (version >= 2);
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
            EnumSet<Flag> flags = Flag.deserialize(body.readByte());
            List<Object> values = flags.contains((Object)Flag.VALUES) ? CBUtil.readValueList(body) : Collections.emptyList();
            boolean skipMetadata = flags.contains((Object)Flag.SKIP_METADATA);
            flags.remove((Object)Flag.VALUES);
            flags.remove((Object)Flag.SKIP_METADATA);
            SpecificOptions options = SpecificOptions.DEFAULT;
            if (!flags.isEmpty()) {
                int pageSize = flags.contains((Object)Flag.PAGE_SIZE) ? body.readInt() : -1;
                PagingState pagingState = flags.contains((Object)Flag.PAGING_STATE) ? PagingState.deserialize(CBUtil.readValue(body)) : null;
                ConsistencyLevel serialConsistency = flags.contains((Object)Flag.SERIAL_CONSISTENCY) ? CBUtil.readConsistencyLevel(body) : ConsistencyLevel.SERIAL;
                options = new SpecificOptions(pageSize, pagingState, serialConsistency);
            }
            return new QueryOptions(consistency, values, skipMetadata, options, version);
        }

        @Override
        public void encode(QueryOptions options, ChannelBuffer dest, int version) {
            assert (version >= 2);
            CBUtil.writeConsistencyLevel(options.getConsistency(), dest);
            EnumSet<Flag> flags = this.gatherFlags(options);
            dest.writeByte((int)((byte)Flag.serialize(flags)));
            if (flags.contains((Object)Flag.VALUES)) {
                CBUtil.writeValueList(options.getValues(), dest);
            }
            if (flags.contains((Object)Flag.PAGE_SIZE)) {
                dest.writeInt(options.getPageSize());
            }
            if (flags.contains((Object)Flag.PAGING_STATE)) {
                CBUtil.writeValue(options.getPagingState().serialize(), dest);
            }
            if (flags.contains((Object)Flag.SERIAL_CONSISTENCY)) {
                CBUtil.writeConsistencyLevel(options.getSerialConsistency(), dest);
            }
        }

        @Override
        public int encodedSize(QueryOptions options, int version) {
            int size = 0;
            size += CBUtil.sizeOfConsistencyLevel(options.getConsistency());
            EnumSet<Flag> flags = this.gatherFlags(options);
            ++size;
            if (flags.contains((Object)Flag.VALUES)) {
                size += CBUtil.sizeOfValueList(options.getValues());
            }
            if (flags.contains((Object)Flag.PAGE_SIZE)) {
                size += 4;
            }
            if (flags.contains((Object)Flag.PAGING_STATE)) {
                size += CBUtil.sizeOfValue(options.getPagingState().serialize());
            }
            if (flags.contains((Object)Flag.SERIAL_CONSISTENCY)) {
                size += CBUtil.sizeOfConsistencyLevel(options.getSerialConsistency());
            }
            return size;
        }

        private EnumSet<Flag> gatherFlags(QueryOptions options) {
            EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
            if (options.getValues().size() > 0) {
                flags.add(Flag.VALUES);
            }
            if (options.skipMetadata) {
                flags.add(Flag.SKIP_METADATA);
            }
            if (options.getPageSize() >= 0) {
                flags.add(Flag.PAGE_SIZE);
            }
            if (options.getPagingState() != null) {
                flags.add(Flag.PAGING_STATE);
            }
            if (options.getSerialConsistency() != ConsistencyLevel.SERIAL) {
                flags.add(Flag.SERIAL_CONSISTENCY);
            }
            return flags;
        }

        private static enum Flag {
            VALUES,
            SKIP_METADATA,
            PAGE_SIZE,
            PAGING_STATE,
            SERIAL_CONSISTENCY;

            private static final Flag[] ALL_VALUES;

            public static EnumSet<Flag> deserialize(int flags) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                for (int n = 0; n < ALL_VALUES.length; ++n) {
                    if ((flags & 1 << n) == 0) continue;
                    set.add(ALL_VALUES[n]);
                }
                return set;
            }

            public static int serialize(EnumSet<Flag> flags) {
                int i = 0;
                for (Flag flag : flags) {
                    i |= 1 << flag.ordinal();
                }
                return i;
            }

            static {
                ALL_VALUES = Flag.values();
            }
        }
    }

    private static class SpecificOptions {
        private static final SpecificOptions DEFAULT = new SpecificOptions(-1, null, null);
        private final int pageSize;
        private final PagingState state;
        private final ConsistencyLevel serialConsistency;

        private SpecificOptions(int pageSize, PagingState state, ConsistencyLevel serialConsistency) {
            this.pageSize = pageSize;
            this.state = state;
            this.serialConsistency = serialConsistency == null ? ConsistencyLevel.SERIAL : serialConsistency;
        }
    }
}

