/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.functions;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.Schema;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnNameBuilder;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.functions.AbstractFunction;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.functions.Function;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.IPartitioner;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import java.nio.ByteBuffer;
import java.util.List;

public class TokenFct
extends AbstractFunction {
    private static final IPartitioner partitioner = StorageService.getPartitioner();
    public static final Function.Factory factory = new Function.Factory(){

        @Override
        public Function create(String ksName, String cfName) {
            return new TokenFct(Schema.instance.getCFMetaData(ksName, cfName));
        }
    };
    private final CFDefinition cfDef;

    public TokenFct(CFMetaData cfm) {
        super("token", partitioner.getTokenValidator(), TokenFct.getKeyTypes(cfm));
        this.cfDef = cfm.getCfDef();
    }

    private static AbstractType[] getKeyTypes(CFMetaData cfm) {
        AbstractType[] types = new AbstractType[cfm.getCfDef().partitionKeyCount()];
        int i = 0;
        for (CFDefinition.Name name : cfm.getCfDef().partitionKeys()) {
            types[i++] = name.type;
        }
        return types;
    }

    @Override
    public ByteBuffer execute(List<ByteBuffer> parameters) throws InvalidRequestException {
        ColumnNameBuilder builder = this.cfDef.getKeyNameBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            ByteBuffer bb = parameters.get(i);
            if (bb == null) {
                return null;
            }
            builder.add(bb);
        }
        return partitioner.getTokenFactory().toByteArray(partitioner.getToken(builder.build()));
    }
}

