/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Permission;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.ColumnDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.Schema;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFName;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnIdentifier;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.IndexPropDefs;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.MigrationManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.IndexType;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.ThriftValidation;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIndexStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(CreateIndexStatement.class);
    private final String indexName;
    private final ColumnIdentifier.Raw rawColumnName;
    private final IndexPropDefs properties;
    private final boolean ifNotExists;

    public CreateIndexStatement(CFName name, String indexName, ColumnIdentifier.Raw rawColumnName, IndexPropDefs properties, boolean ifNotExists) {
        super(name);
        this.indexName = indexName;
        this.rawColumnName = rawColumnName;
        this.properties = properties;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        if (cfm.getDefaultValidator().isCommutative()) {
            throw new InvalidRequestException("Secondary indexes are not supported on counter tables");
        }
        ColumnIdentifier columnName = this.rawColumnName.prepare(cfm);
        ColumnDefinition cd = cfm.getColumnDefinition(columnName.key);
        if (cd == null) {
            throw new InvalidRequestException("No column definition found for column " + columnName);
        }
        if (cd.getIndexType() != null) {
            if (this.ifNotExists) {
                return;
            }
            throw new InvalidRequestException("Index already exists");
        }
        this.properties.validate();
        if (!(!cfm.getCfDef().isCompact && cfm.getCfDef().isComposite || cd.type != ColumnDefinition.Type.PARTITION_KEY && cd.type != ColumnDefinition.Type.CLUSTERING_KEY)) {
            throw new InvalidRequestException("Secondary indexes are not supported on PRIMARY KEY columns in COMPACT STORAGE tables");
        }
        if (cd.type == ColumnDefinition.Type.COMPACT_VALUE) {
            throw new InvalidRequestException("Secondary indexes are not supported on COMPACT STORAGE tables that have clustering columns");
        }
        if (cd.type == ColumnDefinition.Type.STATIC) {
            throw new InvalidRequestException("Secondary indexes are not allowed on static columns");
        }
        if (cd.getValidator().isCollection() && !this.properties.isCustom) {
            throw new InvalidRequestException("Indexes on collections are no yet supported");
        }
        if (cd.type == ColumnDefinition.Type.PARTITION_KEY && cd.componentIndex == null) {
            throw new InvalidRequestException(String.format("Cannot add secondary index to already primarily indexed column %s", columnName));
        }
    }

    @Override
    public boolean announceMigration() throws RequestValidationException {
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily()).clone();
        ColumnIdentifier columnName = this.rawColumnName.prepare(cfm);
        logger.debug("Updating column {} definition for index {}", (Object)columnName, (Object)this.indexName);
        ColumnDefinition cd = cfm.getColumnDefinition(columnName.key);
        if (cd.getIndexType() != null && this.ifNotExists) {
            return false;
        }
        if (this.properties.isCustom) {
            cd.setIndexType(IndexType.CUSTOM, this.properties.getOptions());
        } else if (cfm.getCfDef().isComposite) {
            cd.setIndexType(IndexType.COMPOSITES, Collections.emptyMap());
        } else {
            cd.setIndexType(IndexType.KEYS, Collections.emptyMap());
        }
        cd.setIndexName(this.indexName);
        cfm.addDefaultIndexNames();
        MigrationManager.announceColumnFamilyUpdate(cfm, false);
        return true;
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }
}

