/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.AbstractMarker;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.Term;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.Tuples;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.Bound;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.Restriction;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.SingleColumnRestriction;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface MultiColumnRestriction
extends Restriction {

    public static class Slice
    extends SingleColumnRestriction.Slice
    implements MultiColumnRestriction {
        public Slice(boolean onToken) {
            super(onToken);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public ByteBuffer bound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
            throw new UnsupportedOperationException("Multicolumn slice restrictions do not support bound()");
        }

        public List<ByteBuffer> componentBounds(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
            Term.Terminal terminal = this.bounds[b.idx].bind(variables);
            if (terminal instanceof Tuples.Value) {
                return ((Tuples.Value)terminal).getElements();
            }
            return Collections.singletonList(terminal.get());
        }
    }

    public static class InWithMarker
    extends SingleColumnRestriction.InWithMarker
    implements IN {
        public InWithMarker(AbstractMarker marker) {
            super(marker);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public List<List<ByteBuffer>> splitValues(List<ByteBuffer> variables) throws InvalidRequestException {
            Term.Terminal inValue = ((Tuples.InMarker)this.marker).bind((List)variables);
            if (inValue == null) {
                throw new InvalidRequestException("Invalid null value for IN restriction");
            }
            return ((Tuples.InValue)inValue).getSplitValues();
        }
    }

    public static class InWithValues
    extends SingleColumnRestriction.InWithValues
    implements IN {
        public InWithValues(List<Term> values) {
            super(values);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public List<List<ByteBuffer>> splitValues(List<ByteBuffer> variables) throws InvalidRequestException {
            ArrayList<List<ByteBuffer>> buffers = new ArrayList<List<ByteBuffer>>(this.values.size());
            for (Term value : this.values) {
                Term.MultiItemTerminal term = (Term.MultiItemTerminal)value.bind(variables);
                buffers.add(term.getElements());
            }
            return buffers;
        }
    }

    public static interface IN
    extends MultiColumnRestriction {
        public List<List<ByteBuffer>> splitValues(List<ByteBuffer> var1) throws InvalidRequestException;
    }

    public static class EQ
    extends SingleColumnRestriction.EQ
    implements MultiColumnRestriction {
        public EQ(Term value, boolean onToken) {
            super(value, onToken);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public List<ByteBuffer> values(List<ByteBuffer> variables) throws InvalidRequestException {
            Tuples.Value t = (Tuples.Value)this.value.bind(variables);
            return t.getElements();
        }
    }
}

