/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.AbstractMarker;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.Relation;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.Term;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.Bound;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.Restriction;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.IndexOperator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SingleColumnRestriction
implements Restriction {
    @Override
    public boolean isMultiColumn() {
        return false;
    }

    public static class Slice
    extends SingleColumnRestriction
    implements Restriction.Slice {
        protected final Term[] bounds = new Term[2];
        protected final boolean[] boundInclusive = new boolean[2];
        protected final boolean onToken;

        public Slice(boolean onToken) {
            this.onToken = onToken;
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public List<ByteBuffer> values(List<ByteBuffer> variables) throws InvalidRequestException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOnToken() {
            return this.onToken;
        }

        @Override
        public boolean hasBound(Bound b) {
            return this.bounds[b.idx] != null;
        }

        @Override
        public Term bound(Bound b) {
            return this.bounds[b.idx];
        }

        @Override
        public ByteBuffer bound(Bound b, List<ByteBuffer> variables) throws InvalidRequestException {
            return this.bounds[b.idx].bindAndGet(variables);
        }

        @Override
        public boolean isInclusive(Bound b) {
            return this.bounds[b.idx] == null || this.boundInclusive[b.idx];
        }

        @Override
        public Relation.Type getRelation(Bound eocBound, Bound inclusiveBound) {
            switch (eocBound) {
                case START: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.GTE : Relation.Type.GT;
                }
                case END: {
                    return this.boundInclusive[inclusiveBound.idx] ? Relation.Type.LTE : Relation.Type.LT;
                }
            }
            throw new AssertionError();
        }

        @Override
        public IndexOperator getIndexOperator(Bound b) {
            switch (b) {
                case START: {
                    return this.boundInclusive[b.idx] ? IndexOperator.GTE : IndexOperator.GT;
                }
                case END: {
                    return this.boundInclusive[b.idx] ? IndexOperator.LTE : IndexOperator.LT;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void setBound(Relation.Type type, Term t) throws InvalidRequestException {
            boolean inclusive;
            Bound b;
            switch (type) {
                case GT: {
                    b = Bound.START;
                    inclusive = false;
                    break;
                }
                case GTE: {
                    b = Bound.START;
                    inclusive = true;
                    break;
                }
                case LT: {
                    b = Bound.END;
                    inclusive = false;
                    break;
                }
                case LTE: {
                    b = Bound.END;
                    inclusive = true;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.setBound(b, inclusive, t);
        }

        @Override
        public void setBound(Restriction.Slice slice) throws InvalidRequestException {
            for (Bound bound : Bound.values()) {
                if (!slice.hasBound(bound)) continue;
                this.setBound(bound, slice.isInclusive(bound), slice.bound(bound));
            }
        }

        private void setBound(Bound bound, boolean inclusive, Term term) throws InvalidRequestException {
            if (this.bounds[bound.idx] != null) {
                throw new InvalidRequestException(String.format("More than one restriction was found for the %s bound", bound.name().toLowerCase()));
            }
            this.bounds[bound.idx] = term;
            this.boundInclusive[bound.idx] = inclusive;
        }

        public String toString() {
            return String.format("SLICE(%s %s, %s %s)%s", this.boundInclusive[0] ? ">=" : ">", this.bounds[0], this.boundInclusive[1] ? "<=" : "<", this.bounds[1], this.onToken ? "*" : "");
        }
    }

    public static class InWithMarker
    extends SingleColumnRestriction
    implements Restriction.IN {
        protected final AbstractMarker marker;

        public InWithMarker(AbstractMarker marker) {
            this.marker = marker;
        }

        @Override
        public List<ByteBuffer> values(List<ByteBuffer> variables) throws InvalidRequestException {
            Term.MultiItemTerminal lval = (Term.MultiItemTerminal)this.marker.bind(variables);
            if (lval == null) {
                throw new InvalidRequestException("Invalid null value for IN restriction");
            }
            return lval.getElements();
        }

        @Override
        public boolean canHaveOnlyOneValue() {
            return false;
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return true;
        }

        @Override
        public boolean isOnToken() {
            return false;
        }

        public String toString() {
            return "IN ?";
        }
    }

    public static class InWithValues
    extends SingleColumnRestriction
    implements Restriction.IN {
        protected final List<Term> values;

        public InWithValues(List<Term> values) {
            this.values = values;
        }

        @Override
        public List<ByteBuffer> values(List<ByteBuffer> variables) throws InvalidRequestException {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.values.size());
            for (Term value : this.values) {
                buffers.add(value.bindAndGet(variables));
            }
            return buffers;
        }

        @Override
        public boolean canHaveOnlyOneValue() {
            return this.values.size() == 1;
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return false;
        }

        @Override
        public boolean isIN() {
            return true;
        }

        @Override
        public boolean isOnToken() {
            return false;
        }

        public String toString() {
            return String.format("IN(%s)", this.values);
        }
    }

    public static class EQ
    extends SingleColumnRestriction
    implements Restriction.EQ {
        protected final Term value;
        private final boolean onToken;

        public EQ(Term value, boolean onToken) {
            this.value = value;
            this.onToken = onToken;
        }

        @Override
        public List<ByteBuffer> values(List<ByteBuffer> variables) throws InvalidRequestException {
            return Collections.singletonList(this.value.bindAndGet(variables));
        }

        @Override
        public boolean isSlice() {
            return false;
        }

        @Override
        public boolean isEQ() {
            return true;
        }

        @Override
        public boolean isIN() {
            return false;
        }

        @Override
        public boolean isOnToken() {
            return this.onToken;
        }

        public String toString() {
            return String.format("EQ(%s)%s", this.value, this.onToken ? "*" : "");
        }
    }
}

