/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.compaction.CompactionTask;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTableReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTableWriter;
import java.util.Collection;

public class LeveledCompactionTask
extends CompactionTask {
    private final int level;
    private final long maxSSTableBytes;

    public LeveledCompactionTask(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int level, int gcBefore, long maxSSTableBytes) {
        super(cfs, sstables, gcBefore);
        this.level = level;
        this.maxSSTableBytes = maxSSTableBytes;
    }

    @Override
    protected boolean newSSTableSegmentThresholdReached(SSTableWriter writer) {
        return writer.getOnDiskFilePointer() > this.maxSSTableBytes;
    }

    @Override
    protected boolean partialCompactionsAcceptable() {
        return false;
    }

    @Override
    protected int getLevel() {
        return this.level;
    }
}

