/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.filter;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Memtable;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.OnDiskAtom;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowIndexEntry;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.IDiskAtomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.NamesQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.SliceQueryFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTableReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileDataInput;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.HeapAllocator;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.IMergeIterator;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.MergeIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class QueryFilter {
    public final DecoratedKey key;
    public final String cfName;
    public final IDiskAtomFilter filter;
    public final long timestamp;

    public QueryFilter(DecoratedKey key, String cfName, IDiskAtomFilter filter, long timestamp) {
        this.key = key;
        this.cfName = cfName;
        this.filter = filter;
        this.timestamp = timestamp;
    }

    public OnDiskAtomIterator getMemtableColumnIterator(Memtable memtable) {
        ColumnFamily cf = memtable.getColumnFamily(this.key);
        if (cf == null) {
            return null;
        }
        return this.getColumnFamilyIterator(cf);
    }

    public OnDiskAtomIterator getColumnFamilyIterator(ColumnFamily cf) {
        assert (cf != null);
        return this.filter.getColumnFamilyIterator(this.key, cf);
    }

    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader sstable) {
        return this.filter.getSSTableColumnIterator(sstable, this.key);
    }

    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry) {
        return this.filter.getSSTableColumnIterator(sstable, file, key, indexEntry);
    }

    public void collateOnDiskAtom(ColumnFamily returnCF, List<? extends Iterator<? extends OnDiskAtom>> toCollate, int gcBefore) {
        QueryFilter.collateOnDiskAtom(returnCF, toCollate, this.filter, gcBefore, this.timestamp);
    }

    public static void collateOnDiskAtom(ColumnFamily returnCF, List<? extends Iterator<? extends OnDiskAtom>> toCollate, IDiskAtomFilter filter, int gcBefore, long timestamp) {
        ArrayList<Iterator<Column>> filteredIterators = new ArrayList<Iterator<Column>>(toCollate.size());
        for (Iterator<? extends OnDiskAtom> iterator : toCollate) {
            filteredIterators.add(QueryFilter.gatherTombstones(returnCF, iterator));
        }
        QueryFilter.collateColumns(returnCF, filteredIterators, filter, gcBefore, timestamp);
    }

    public void collateOnDiskAtom(ColumnFamily returnCF, Iterator<? extends OnDiskAtom> toCollate, int gcBefore) {
        Iterator<Column> columns = QueryFilter.gatherTombstones(returnCF, toCollate);
        this.filter.collectReducedColumns(returnCF, columns, gcBefore, this.timestamp);
    }

    public void collateColumns(ColumnFamily returnCF, List<? extends Iterator<Column>> toCollate, int gcBefore) {
        QueryFilter.collateColumns(returnCF, toCollate, this.filter, gcBefore, this.timestamp);
    }

    public static void collateColumns(ColumnFamily returnCF, List<? extends Iterator<Column>> toCollate, IDiskAtomFilter filter, int gcBefore, long timestamp) {
        final Comparator<Column> fcomp = filter.getColumnComparator(returnCF.getComparator());
        MergeIterator.Reducer<Column, Column> reducer = new MergeIterator.Reducer<Column, Column>(){
            Column current;

            @Override
            public void reduce(Column next) {
                assert (this.current == null || fcomp.compare(this.current, next) == 0);
                this.current = this.current == null ? next : this.current.reconcile(next, HeapAllocator.instance);
            }

            @Override
            protected Column getReduced() {
                assert (this.current != null);
                Column toReturn = this.current;
                this.current = null;
                return toReturn;
            }
        };
        IMergeIterator<Column, Column> reduced = MergeIterator.get(toCollate, fcomp, reducer);
        filter.collectReducedColumns(returnCF, reduced, gcBefore, timestamp);
    }

    public static Iterator<Column> gatherTombstones(final ColumnFamily returnCF, final Iterator<? extends OnDiskAtom> iter) {
        return new Iterator<Column>(){
            private Column next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                this.getNext();
                return this.next != null;
            }

            @Override
            public Column next() {
                if (this.next == null) {
                    this.getNext();
                }
                assert (this.next != null);
                Column toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            private void getNext() {
                while (iter.hasNext()) {
                    OnDiskAtom atom = (OnDiskAtom)iter.next();
                    if (atom instanceof Column) {
                        this.next = (Column)atom;
                        break;
                    }
                    returnCF.addAtom(atom);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getColumnFamilyName() {
        return this.cfName;
    }

    public static QueryFilter getSliceFilter(DecoratedKey key, String cfName, ByteBuffer start, ByteBuffer finish, boolean reversed, int limit, long timestamp) {
        return new QueryFilter(key, cfName, new SliceQueryFilter(start, finish, reversed, limit), timestamp);
    }

    public static QueryFilter getIdentityFilter(DecoratedKey key, String cfName, long timestamp) {
        return new QueryFilter(key, cfName, new IdentityQueryFilter(), timestamp);
    }

    public static QueryFilter getNamesFilter(DecoratedKey key, String cfName, SortedSet<ByteBuffer> columns, long timestamp) {
        return new QueryFilter(key, cfName, new NamesQueryFilter(columns), timestamp);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(key=" + this.key + ", cfName=" + this.cfName + (this.filter == null ? "" : ", filter=" + this.filter) + ")";
    }

    public boolean shouldInclude(SSTableReader sstable) {
        return this.filter.shouldInclude(sstable);
    }
}

