/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.index;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.ExtendedFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.SecondaryIndex;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.SecondaryIndexManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.IndexExpression;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.IndexOperator;
import com.netflix.astyanax.shaded.org.apache.cassandra.tracing.Tracing;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class SecondaryIndexSearcher {
    protected final SecondaryIndexManager indexManager;
    protected final Set<ByteBuffer> columns;
    protected final ColumnFamilyStore baseCfs;

    public SecondaryIndexSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        this.indexManager = indexManager;
        this.columns = columns;
        this.baseCfs = indexManager.baseCfs;
    }

    public abstract List<Row> search(ExtendedFilter var1);

    public boolean isIndexing(List<IndexExpression> clause) {
        return this.highestSelectivityPredicate(clause) != null;
    }

    protected IndexExpression highestSelectivityPredicate(List<IndexExpression> clause) {
        IndexExpression best = null;
        int bestMeanCount = Integer.MAX_VALUE;
        HashMap<SecondaryIndex, Integer> candidates = new HashMap<SecondaryIndex, Integer>();
        for (IndexExpression expression : clause) {
            SecondaryIndex index;
            if (!this.columns.contains(expression.column_name) || (index = this.indexManager.getIndexForColumn(expression.column_name)) == null || index.getIndexCfs() == null || expression.op != IndexOperator.EQ) continue;
            int columns = index.getIndexCfs().getMeanColumns();
            candidates.put(index, columns);
            if (columns >= bestMeanCount) continue;
            best = expression;
            bestMeanCount = columns;
        }
        if (best == null) {
            Tracing.trace("No applicable indexes found");
        } else {
            Tracing.trace("Candidate index mean cardinalities are {}. Scanning with {}.", FBUtilities.toString(candidates), this.indexManager.getIndexForColumn(best.column_name).getIndexName());
        }
        return best;
    }
}

