/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.io.util;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.IAllocator;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.NativeAllocator;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public class Memory {
    private static final Unsafe unsafe = NativeAllocator.unsafe;
    private static final IAllocator allocator = DatabaseDescriptor.getoffHeapMemoryAllocator();
    private static final long BYTE_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
    private static final boolean bigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    private static final boolean unaligned;
    protected long peer;
    private final long size;

    protected Memory(long bytes) {
        this.size = bytes;
        this.peer = allocator.allocate(this.size);
    }

    public static Memory allocate(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException();
        }
        return new Memory(bytes);
    }

    public void setByte(long offset, byte b) {
        this.checkPosition(offset);
        unsafe.putByte(this.peer + offset, b);
    }

    public void setMemory(long offset, long bytes, byte b) {
        this.checkPosition(offset + bytes - 1L);
        unsafe.setMemory(this.peer + offset, bytes, b);
    }

    public void setLong(long offset, long l) {
        this.checkPosition(offset);
        if (unaligned) {
            unsafe.putLong(this.peer + offset, l);
        } else {
            this.putLongByByte(this.peer + offset, l);
        }
    }

    private void putLongByByte(long address, long value) {
        if (bigEndian) {
            unsafe.putByte(address, (byte)(value >> 56));
            unsafe.putByte(address + 1L, (byte)(value >> 48));
            unsafe.putByte(address + 2L, (byte)(value >> 40));
            unsafe.putByte(address + 3L, (byte)(value >> 32));
            unsafe.putByte(address + 4L, (byte)(value >> 24));
            unsafe.putByte(address + 5L, (byte)(value >> 16));
            unsafe.putByte(address + 6L, (byte)(value >> 8));
            unsafe.putByte(address + 7L, (byte)value);
        } else {
            unsafe.putByte(address + 7L, (byte)(value >> 56));
            unsafe.putByte(address + 6L, (byte)(value >> 48));
            unsafe.putByte(address + 5L, (byte)(value >> 40));
            unsafe.putByte(address + 4L, (byte)(value >> 32));
            unsafe.putByte(address + 3L, (byte)(value >> 24));
            unsafe.putByte(address + 2L, (byte)(value >> 16));
            unsafe.putByte(address + 1L, (byte)(value >> 8));
            unsafe.putByte(address, (byte)value);
        }
    }

    public void setInt(long offset, int l) {
        this.checkPosition(offset);
        if (unaligned) {
            unsafe.putInt(this.peer + offset, l);
        } else {
            this.putIntByByte(this.peer + offset, l);
        }
    }

    private void putIntByByte(long address, int value) {
        if (bigEndian) {
            unsafe.putByte(address, (byte)(value >> 24));
            unsafe.putByte(address + 1L, (byte)(value >> 16));
            unsafe.putByte(address + 2L, (byte)(value >> 8));
            unsafe.putByte(address + 3L, (byte)value);
        } else {
            unsafe.putByte(address + 3L, (byte)(value >> 24));
            unsafe.putByte(address + 2L, (byte)(value >> 16));
            unsafe.putByte(address + 1L, (byte)(value >> 8));
            unsafe.putByte(address, (byte)value);
        }
    }

    public void setBytes(long memoryOffset, byte[] buffer, int bufferOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (bufferOffset < 0 || count < 0 || bufferOffset + count > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.checkPosition(memoryOffset);
        long end = memoryOffset + (long)count;
        this.checkPosition(end - 1L);
        unsafe.copyMemory(buffer, BYTE_ARRAY_BASE_OFFSET + (long)bufferOffset, null, this.peer + memoryOffset, count);
    }

    public byte getByte(long offset) {
        this.checkPosition(offset);
        return unsafe.getByte(this.peer + offset);
    }

    public long getLong(long offset) {
        this.checkPosition(offset);
        if (unaligned) {
            return unsafe.getLong(this.peer + offset);
        }
        return this.getLongByByte(this.peer + offset);
    }

    private long getLongByByte(long address) {
        if (bigEndian) {
            return (long)unsafe.getByte(address) << 56 | ((long)unsafe.getByte(address + 1L) & 0xFFL) << 48 | ((long)unsafe.getByte(address + 2L) & 0xFFL) << 40 | ((long)unsafe.getByte(address + 3L) & 0xFFL) << 32 | ((long)unsafe.getByte(address + 4L) & 0xFFL) << 24 | ((long)unsafe.getByte(address + 5L) & 0xFFL) << 16 | ((long)unsafe.getByte(address + 6L) & 0xFFL) << 8 | (long)unsafe.getByte(address + 7L) & 0xFFL;
        }
        return (long)unsafe.getByte(address + 7L) << 56 | ((long)unsafe.getByte(address + 6L) & 0xFFL) << 48 | ((long)unsafe.getByte(address + 5L) & 0xFFL) << 40 | ((long)unsafe.getByte(address + 4L) & 0xFFL) << 32 | ((long)unsafe.getByte(address + 3L) & 0xFFL) << 24 | ((long)unsafe.getByte(address + 2L) & 0xFFL) << 16 | ((long)unsafe.getByte(address + 1L) & 0xFFL) << 8 | (long)unsafe.getByte(address) & 0xFFL;
    }

    public int getInt(long offset) {
        this.checkPosition(offset);
        if (unaligned) {
            return unsafe.getInt(this.peer + offset);
        }
        return this.getIntByByte(this.peer + offset);
    }

    private int getIntByByte(long address) {
        if (bigEndian) {
            return unsafe.getByte(address) << 24 | (unsafe.getByte(address + 1L) & 0xFF) << 16 | (unsafe.getByte(address + 2L) & 0xFF) << 8 | unsafe.getByte(address + 3L) & 0xFF;
        }
        return unsafe.getByte(address + 3L) << 24 | (unsafe.getByte(address + 2L) & 0xFF) << 16 | (unsafe.getByte(address + 1L) & 0xFF) << 8 | unsafe.getByte(address) & 0xFF;
    }

    public void getBytes(long memoryOffset, byte[] buffer, int bufferOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (bufferOffset < 0 || count < 0 || count > buffer.length - bufferOffset) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.checkPosition(memoryOffset);
        long end = memoryOffset + (long)count;
        this.checkPosition(end - 1L);
        unsafe.copyMemory(null, this.peer + memoryOffset, buffer, BYTE_ARRAY_BASE_OFFSET + (long)bufferOffset, count);
    }

    private void checkPosition(long offset) {
        assert (this.peer != 0L) : "Memory was freed";
        assert (offset >= 0L && offset < this.size) : "Illegal offset: " + offset + ", size: " + this.size;
    }

    public void free() {
        assert (this.peer != 0L);
        allocator.free(this.peer);
        this.peer = 0L;
    }

    public long size() {
        assert (this.peer != 0L);
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Memory)) {
            return false;
        }
        Memory b = (Memory)o;
        return this.peer == b.peer && this.size == b.size;
    }

    static {
        String arch = System.getProperty("os.arch");
        unaligned = arch.equals("i386") || arch.equals("x86") || arch.equals("amd64") || arch.equals("x86_64");
    }
}

