/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.io.util;

import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileDataInput;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.RandomAccessReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.SegmentedFile;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.FileCacheService;

public abstract class PoolingSegmentedFile
extends SegmentedFile {
    protected PoolingSegmentedFile(String path, long length) {
        super(path, length);
    }

    protected PoolingSegmentedFile(String path, long length, long onDiskLength) {
        super(path, length, onDiskLength);
    }

    @Override
    public FileDataInput getSegment(long position) {
        RandomAccessReader reader = FileCacheService.instance.get(this.path);
        if (reader == null) {
            reader = this.createReader(this.path);
        }
        reader.seek(position);
        return reader;
    }

    protected abstract RandomAccessReader createReader(String var1);

    public void recycle(RandomAccessReader reader) {
        FileCacheService.instance.put(reader);
    }

    @Override
    public void cleanup() {
        FileCacheService.instance.invalidate(this.path);
    }
}

