/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.net;

import com.google.common.collect.ImmutableMap;
import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.Stage;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileUtils;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.CallbackInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.CompactEndpointSerializationHelper;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import java.io.DataInput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageIn<T> {
    private static final Logger logger = LoggerFactory.getLogger(MessageIn.class);
    public final InetAddress from;
    public final T payload;
    public final Map<String, byte[]> parameters;
    public final MessagingService.Verb verb;
    public final int version;

    private MessageIn(InetAddress from, T payload, Map<String, byte[]> parameters, MessagingService.Verb verb, int version) {
        this.from = from;
        this.payload = payload;
        this.parameters = parameters;
        this.verb = verb;
        this.version = version;
    }

    public static <T> MessageIn<T> create(InetAddress from, T payload, Map<String, byte[]> parameters, MessagingService.Verb verb, int version) {
        return new MessageIn<T>(from, payload, parameters, verb, version);
    }

    public static <T2> MessageIn<T2> read(DataInput in, int version, int id) throws IOException {
        ImmutableMap parameters;
        InetAddress from = CompactEndpointSerializationHelper.deserialize(in);
        MessagingService.Verb verb = MessagingService.Verb.values()[in.readInt()];
        int parameterCount = in.readInt();
        if (parameterCount == 0) {
            parameters = Collections.emptyMap();
        } else {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < parameterCount; ++i) {
                String key = in.readUTF();
                byte[] value = new byte[in.readInt()];
                in.readFully(value);
                builder.put((Object)key, (Object)value);
            }
            parameters = builder.build();
        }
        int payloadSize = in.readInt();
        IVersionedSerializer<?> serializer = MessagingService.verbSerializers.get((Object)verb);
        if (serializer instanceof MessagingService.CallbackDeterminedSerializer) {
            CallbackInfo callback = MessagingService.instance().getRegisteredCallback(id);
            if (callback == null) {
                FileUtils.skipBytesFully(in, payloadSize);
                return null;
            }
            serializer = callback.serializer;
        }
        if (payloadSize == 0 || serializer == null) {
            return MessageIn.create(from, null, (Map<String, byte[]>)parameters, verb, version);
        }
        Object payload = serializer.deserialize(in, version);
        return MessageIn.create(from, payload, (Map<String, byte[]>)parameters, verb, version);
    }

    public Stage getMessageType() {
        return MessagingService.verbStages.get((Object)this.verb);
    }

    public boolean doCallbackOnFailure() {
        return this.parameters.containsKey("CAL_BAC");
    }

    public boolean isFailureResponse() {
        return this.parameters.containsKey("FAIL");
    }

    public long getTimeout() {
        return DatabaseDescriptor.getTimeout(this.verb);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("FROM:").append(this.from).append(" TYPE:").append((Object)this.getMessageType()).append(" VERB:").append((Object)this.verb);
        return sbuf.toString();
    }
}

