/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service;

import com.netflix.astyanax.shaded.org.apache.cassandra.gms.ApplicationState;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.EndpointState;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.Gossiper;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.VersionedValue;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBroadcaster
implements IEndpointStateChangeSubscriber {
    static final int BROADCAST_INTERVAL = 60000;
    public static final LoadBroadcaster instance = new LoadBroadcaster();
    private static final Logger logger = LoggerFactory.getLogger(LoadBroadcaster.class);
    private ConcurrentMap<InetAddress, Double> loadInfo = new ConcurrentHashMap<InetAddress, Double>();

    private LoadBroadcaster() {
        Gossiper.instance.register(this);
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
        if (state != ApplicationState.LOAD) {
            return;
        }
        this.loadInfo.put(endpoint, Double.valueOf(value.value));
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
        VersionedValue localValue = epState.getApplicationState(ApplicationState.LOAD);
        if (localValue != null) {
            this.onChange(endpoint, ApplicationState.LOAD, localValue);
        }
    }

    @Override
    public void beforeChange(InetAddress endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.loadInfo.remove(endpoint);
    }

    public Map<InetAddress, Double> getLoadInfo() {
        return Collections.unmodifiableMap(this.loadInfo);
    }

    public void startBroadcasting() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (logger.isDebugEnabled()) {
                    logger.debug("Disseminating load info ...");
                }
                Gossiper.instance.addLocalApplicationState(ApplicationState.LOAD, StorageService.instance.valueFactory.load(StorageService.instance.getLoad()));
            }
        };
        StorageService.scheduledTasks.scheduleWithFixedDelay(runnable, 2000L, 60000L, TimeUnit.MILLISECONDS);
    }
}

