/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming;

import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.Component;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTableReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.DataIntegrityMetadata;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileUtils;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.RandomAccessReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.ProgressInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamSession;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import com.ning.compress.lzf.LZFOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;

public class StreamWriter {
    private static final int DEFAULT_CHUNK_SIZE = 65536;
    protected final SSTableReader sstable;
    protected final Collection<Pair<Long, Long>> sections;
    protected final StreamManager.StreamRateLimiter limiter;
    protected final StreamSession session;
    private OutputStream compressedOutput;
    private byte[] transferBuffer;

    public StreamWriter(SSTableReader sstable, Collection<Pair<Long, Long>> sections, StreamSession session) {
        this.session = session;
        this.sstable = sstable;
        this.sections = sections;
        this.limiter = StreamManager.getRateLimiter(session.peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(WritableByteChannel channel) throws IOException {
        long totalSize = this.totalSize();
        RandomAccessReader file = this.sstable.openDataReader();
        DataIntegrityMetadata.ChecksumValidator validator = new File(this.sstable.descriptor.filenameFor(Component.CRC)).exists() ? DataIntegrityMetadata.checksumValidator(this.sstable.descriptor) : null;
        this.transferBuffer = validator == null ? new byte[65536] : new byte[validator.chunkSize];
        this.compressedOutput = new LZFOutputStream(Channels.newOutputStream(channel));
        long progress = 0L;
        try {
            for (Pair<Long, Long> section : this.sections) {
                long lastBytesRead;
                long start = validator == null ? ((Long)section.left).longValue() : validator.chunkStart((Long)section.left);
                int readOffset = (int)((Long)section.left - start);
                file.seek(start);
                if (validator != null) {
                    validator.seek(start);
                }
                long length = (Long)section.right - start;
                for (long bytesRead = 0L; bytesRead < length; bytesRead += lastBytesRead) {
                    lastBytesRead = this.write(file, validator, readOffset, length, bytesRead);
                    this.session.progress(this.sstable.descriptor, ProgressInfo.Direction.OUT, progress += lastBytesRead - (long)readOffset, totalSize);
                    readOffset = 0;
                }
                this.compressedOutput.flush();
            }
        }
        finally {
            FileUtils.closeQuietly(file);
            FileUtils.closeQuietly(validator);
        }
    }

    protected long totalSize() {
        long size = 0L;
        for (Pair<Long, Long> section : this.sections) {
            size += (Long)section.right - (Long)section.left;
        }
        return size;
    }

    protected long write(RandomAccessReader reader, DataIntegrityMetadata.ChecksumValidator validator, int start, long length, long bytesTransferred) throws IOException {
        int toTransfer = (int)Math.min((long)this.transferBuffer.length, length - bytesTransferred);
        int minReadable = (int)Math.min((long)this.transferBuffer.length, reader.length() - reader.getFilePointer());
        reader.readFully(this.transferBuffer, 0, minReadable);
        if (validator != null) {
            validator.validate(this.transferBuffer, 0, minReadable);
        }
        this.limiter.acquire(toTransfer - start);
        this.compressedOutput.write(this.transferBuffer, start, toTransfer - start);
        return toTransfer;
    }
}

