/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming.compress;

import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.compress.CompressionMetadata;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.compress.CompressionInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.WrappedRunnable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class CompressedInputStream
extends InputStream {
    private final CompressionInfo info;
    private final BlockingQueue<byte[]> dataBuffer;
    private byte[] buffer;
    protected long bufferOffset = 0L;
    private long current = 0L;
    protected int validBufferBytes = -1;
    private final Checksum checksum;
    private final byte[] checksumBytes = new byte[4];
    private static final byte[] POISON_PILL = new byte[0];
    private long totalCompressedBytesRead;
    private final boolean hasPostCompressionAdlerChecksums;

    public CompressedInputStream(InputStream source, CompressionInfo info, boolean hasPostCompressionAdlerChecksums) {
        this.info = info;
        this.checksum = hasPostCompressionAdlerChecksums ? new Adler32() : new CRC32();
        this.hasPostCompressionAdlerChecksums = hasPostCompressionAdlerChecksums;
        this.buffer = new byte[info.parameters.chunkLength()];
        this.dataBuffer = new ArrayBlockingQueue<byte[]>(Math.min(info.chunks.length, 1024));
        new Thread(new Reader(source, info, this.dataBuffer)).start();
    }

    @Override
    public int read() throws IOException {
        if (this.current >= this.bufferOffset + (long)this.buffer.length || this.validBufferBytes == -1) {
            try {
                byte[] compressedWithCRC = this.dataBuffer.take();
                if (compressedWithCRC == POISON_PILL) {
                    throw new EOFException("No chunk available");
                }
                this.decompress(compressedWithCRC);
            }
            catch (InterruptedException e) {
                throw new EOFException("No chunk available");
            }
        }
        assert (this.current >= this.bufferOffset && this.current < this.bufferOffset + (long)this.validBufferBytes);
        return this.buffer[(int)(this.current++ - this.bufferOffset)] & 0xFF;
    }

    public void position(long position) {
        assert (position >= this.current) : "stream can only read forward.";
        this.current = position;
    }

    private void decompress(byte[] compressed) throws IOException {
        this.validBufferBytes = this.info.parameters.sstableCompressor.uncompress(compressed, 0, compressed.length - this.checksumBytes.length, this.buffer, 0);
        this.totalCompressedBytesRead += (long)compressed.length;
        if (this.info.parameters.getCrcCheckChance() > FBUtilities.threadLocalRandom().nextDouble()) {
            if (this.hasPostCompressionAdlerChecksums) {
                this.checksum.update(compressed, 0, compressed.length - this.checksumBytes.length);
            } else {
                this.checksum.update(this.buffer, 0, this.validBufferBytes);
            }
            System.arraycopy(compressed, compressed.length - this.checksumBytes.length, this.checksumBytes, 0, this.checksumBytes.length);
            if (Ints.fromByteArray((byte[])this.checksumBytes) != (int)this.checksum.getValue()) {
                throw new IOException("CRC unmatched");
            }
            this.checksum.reset();
        }
        this.bufferOffset = this.current & (long)(~(this.buffer.length - 1));
    }

    public long getTotalCompressedBytesRead() {
        return this.totalCompressedBytesRead;
    }

    static class Reader
    extends WrappedRunnable {
        private final InputStream source;
        private final Iterator<CompressionMetadata.Chunk> chunks;
        private final BlockingQueue<byte[]> dataBuffer;

        Reader(InputStream source, CompressionInfo info, BlockingQueue<byte[]> dataBuffer) {
            this.source = source;
            this.chunks = Iterators.forArray((Object[])info.chunks);
            this.dataBuffer = dataBuffer;
        }

        @Override
        protected void runMayThrow() throws Exception {
            while (this.chunks.hasNext()) {
                int r;
                CompressionMetadata.Chunk chunk = this.chunks.next();
                int readLength = chunk.length + 4;
                byte[] compressedWithCRC = new byte[readLength];
                for (int bufferRead = 0; bufferRead < readLength; bufferRead += r) {
                    r = this.source.read(compressedWithCRC, bufferRead, readLength - bufferRead);
                    if (r >= 0) continue;
                    this.dataBuffer.put(POISON_PILL);
                    return;
                }
                this.dataBuffer.put(compressedWithCRC);
            }
        }
    }
}

