/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface OutputHandler {
    public void output(String var1);

    public void debug(String var1);

    public void warn(String var1);

    public void warn(String var1, Throwable var2);

    public static class SystemOutput
    implements OutputHandler {
        public final boolean debug;
        public final boolean printStack;

        public SystemOutput(boolean debug, boolean printStack) {
            this.debug = debug;
            this.printStack = printStack;
        }

        @Override
        public void output(String msg) {
            System.out.println(msg);
        }

        @Override
        public void debug(String msg) {
            if (this.debug) {
                System.out.println(msg);
            }
        }

        @Override
        public void warn(String msg) {
            this.warn(msg, null);
        }

        @Override
        public void warn(String msg, Throwable th) {
            System.out.println("WARNING: " + msg);
            if (this.printStack && th != null) {
                th.printStackTrace(System.out);
            }
        }
    }

    public static class LogOutput
    implements OutputHandler {
        private static Logger logger = LoggerFactory.getLogger(LogOutput.class);

        @Override
        public void output(String msg) {
            logger.info(msg);
        }

        @Override
        public void debug(String msg) {
            logger.debug(msg);
        }

        @Override
        public void warn(String msg) {
            logger.warn(msg);
        }

        @Override
        public void warn(String msg, Throwable th) {
            logger.warn(msg, th);
        }
    }
}

