/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.impl.TokenRangeImpl;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OldHostSupplierAdapter
implements Supplier<List<Host>> {
    private final Supplier<Map<BigInteger, List<Host>>> source;

    public OldHostSupplierAdapter(Supplier<Map<BigInteger, List<Host>>> source) {
        this.source = source;
    }

    public List<Host> get() {
        Map tokenHostMap = (Map)this.source.get();
        HashSet hosts = Sets.newHashSet();
        for (Map.Entry entry : tokenHostMap.entrySet()) {
            for (Host host : (List)entry.getValue()) {
                if (!hosts.contains(host)) {
                    hosts.add(host);
                }
                String token = ((BigInteger)entry.getKey()).toString();
                host.getTokenRanges().add(new TokenRangeImpl(token, token, null));
            }
        }
        return Lists.newArrayList((Iterable)hosts);
    }
}

