/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.retry;

import com.netflix.astyanax.retry.RetryPolicy;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class SleepingRetryPolicy
implements RetryPolicy {
    private final int maxAttempts;
    private int attempts;

    public SleepingRetryPolicy(int max) {
        this.maxAttempts = max;
        this.attempts = 0;
    }

    @Override
    public boolean allowRetry() {
        if (this.maxAttempts == -1 || this.attempts < this.maxAttempts) {
            try {
                Thread.sleep(this.getSleepTimeMs());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            ++this.attempts;
            return true;
        }
        return false;
    }

    public abstract long getSleepTimeMs();

    @Override
    public void begin() {
        this.attempts = 0;
    }

    @Override
    public void success() {
    }

    @Override
    public void failure(Exception e) {
    }

    @Override
    public int getAttemptCount() {
        return this.attempts;
    }

    @Deprecated
    public int getMax() {
        return this.getMaxAttemptCount();
    }

    public int getMaxAttemptCount() {
        return this.maxAttempts;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

