/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.List;
import org.apache.atlas.AtlasException;
import org.apache.atlas.groovy.BinaryExpression;
import org.apache.atlas.groovy.GroovyExpression;

public class ArithmeticExpression
extends BinaryExpression {
    public ArithmeticExpression(GroovyExpression left, ArithmeticOperator op, GroovyExpression right) {
        super(left, op.getGroovyValue(), right);
    }

    private ArithmeticExpression(GroovyExpression left, String op, GroovyExpression right) {
        super(left, op, right);
    }

    @Override
    public GroovyExpression copy(List<GroovyExpression> newChildren) {
        assert (newChildren.size() == 2);
        return new ArithmeticExpression(newChildren.get(0), this.op, newChildren.get(1));
    }

    public static enum ArithmeticOperator {
        PLUS("+"),
        MINUS("-"),
        TIMES("*"),
        DIVIDE("/"),
        MODULUS("%");

        private String groovyValue;

        private ArithmeticOperator(String groovyValue) {
            this.groovyValue = groovyValue;
        }

        public String getGroovyValue() {
            return this.groovyValue;
        }

        public static ArithmeticOperator lookup(String groovyValue) throws AtlasException {
            for (ArithmeticOperator op : ArithmeticOperator.values()) {
                if (!op.getGroovyValue().equals(groovyValue)) continue;
                return op;
            }
            throw new AtlasException("Unknown Operator:" + groovyValue);
        }
    }
}

