/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphIndexClient;
import org.apache.atlas.repository.graphdb.AtlasGraphManagement;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasGraphTraversal;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQueryParameter;
import org.apache.atlas.repository.graphdb.AtlasPropertyKey;
import org.apache.atlas.repository.graphdb.AtlasSchemaViolationException;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.GraphIndexQueryParameters;
import org.apache.atlas.repository.graphdb.GremlinVersion;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraphDatabase;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraphIndexClient;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraphManagement;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraphTraversal;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusIndexQuery;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusIndexQueryParameter;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusObjectFactory;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertex;
import org.apache.atlas.repository.graphdb.janus.GraphDbObjectFactory;
import org.apache.atlas.repository.graphdb.janus.query.AtlasJanusGraphQuery;
import org.apache.atlas.repository.graphdb.utils.IteratorToIterableAdapter;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.Constants;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.Customizer;
import org.apache.tinkerpop.gremlin.jsr223.DefaultImportCustomizer;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ImmutablePath;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphIndexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.SchemaViolationException;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasJanusGraph
implements AtlasGraph<AtlasJanusVertex, AtlasJanusEdge> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasJanusGraph.class);
    private static final Parameter[] EMPTY_PARAMETER_ARRAY = new Parameter[0];
    private static Configuration APPLICATION_PROPERTIES = null;
    private final ConvertGremlinValueFunction GREMLIN_VALUE_CONVERSION_FUNCTION = new ConvertGremlinValueFunction();
    private final Set<String> multiProperties = new HashSet<String>();
    private final StandardJanusGraph janusGraph;
    private final ThreadLocal<GremlinGroovyScriptEngine> scriptEngine = ThreadLocal.withInitial(() -> {
        DefaultImportCustomizer.Builder builder = DefaultImportCustomizer.build().addClassImports(new Class[]{java.util.function.Function.class}).addMethodImports(__.class.getMethods()).addMethodImports(P.class.getMethods());
        return new GremlinGroovyScriptEngine(new Customizer[]{builder.create()});
    });

    public AtlasJanusGraph() {
        this(AtlasJanusGraphDatabase.getGraphInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtlasJanusGraph(JanusGraph graphInstance) {
        JanusGraphManagement mgmt = null;
        try {
            mgmt = graphInstance.openManagement();
            Iterable keys = mgmt.getRelationTypes(PropertyKey.class);
            for (PropertyKey key : keys) {
                if (key.cardinality() == Cardinality.SINGLE) continue;
                this.multiProperties.add(key.name());
            }
        }
        finally {
            if (mgmt != null) {
                mgmt.rollback();
            }
        }
        this.janusGraph = (StandardJanusGraph)graphInstance;
    }

    public AtlasEdge<AtlasJanusVertex, AtlasJanusEdge> addEdge(AtlasVertex<AtlasJanusVertex, AtlasJanusEdge> outVertex, AtlasVertex<AtlasJanusVertex, AtlasJanusEdge> inVertex, String edgeLabel) {
        try {
            Vertex oV = (Vertex)((AtlasJanusVertex)outVertex.getV()).getWrappedElement();
            Vertex iV = (Vertex)((AtlasJanusVertex)inVertex.getV()).getWrappedElement();
            Edge edge = oV.addEdge(edgeLabel, iV, new Object[0]);
            return GraphDbObjectFactory.createEdge(this, edge);
        }
        catch (SchemaViolationException e) {
            throw new AtlasSchemaViolationException((Throwable)e);
        }
    }

    public AtlasGraphQuery<AtlasJanusVertex, AtlasJanusEdge> query() {
        return new AtlasJanusGraphQuery(this);
    }

    public AtlasGraphTraversal<AtlasVertex, AtlasEdge> V(Object ... vertexIds) {
        AtlasJanusGraphTraversal traversal = new AtlasJanusGraphTraversal(this, this.getGraph().traversal());
        traversal.getBytecode().addStep("V", vertexIds);
        traversal.addStep((Step)new GraphStep((Traversal.Admin)traversal, Vertex.class, true, vertexIds));
        return traversal;
    }

    public AtlasGraphTraversal<AtlasVertex, AtlasEdge> E(Object ... edgeIds) {
        AtlasJanusGraphTraversal traversal = new AtlasJanusGraphTraversal(this, this.getGraph().traversal());
        traversal.getBytecode().addStep("E", edgeIds);
        traversal.addStep((Step)new GraphStep((Traversal.Admin)traversal, Vertex.class, true, edgeIds));
        return traversal;
    }

    public AtlasEdge getEdgeBetweenVertices(AtlasVertex fromVertex, AtlasVertex toVertex, String edgeLabel) {
        GraphTraversal gt = this.V(fromVertex.getId()).outE(new String[]{edgeLabel}).where((Traversal)__.otherV().hasId(toVertex.getId(), new Object[0]));
        Edge gremlinEdge = this.getFirstActiveEdge(gt);
        return gremlinEdge != null ? GraphDbObjectFactory.createEdge(this, gremlinEdge) : null;
    }

    public AtlasEdge<AtlasJanusVertex, AtlasJanusEdge> getEdge(String edgeId) {
        Iterator it = this.getGraph().edges(new Object[]{edgeId});
        Edge e = (Edge)AtlasJanusGraph.getSingleElement(it, edgeId);
        return GraphDbObjectFactory.createEdge(this, e);
    }

    public void removeEdge(AtlasEdge<AtlasJanusVertex, AtlasJanusEdge> edge) {
        Edge wrapped = (Edge)((AtlasJanusEdge)edge.getE()).getWrappedElement();
        wrapped.remove();
    }

    public void removeVertex(AtlasVertex<AtlasJanusVertex, AtlasJanusEdge> vertex) {
        Vertex wrapped = (Vertex)((AtlasJanusVertex)vertex.getV()).getWrappedElement();
        wrapped.remove();
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> getEdges() {
        Iterator edges = this.getGraph().edges(new Object[0]);
        return this.wrapEdges(edges);
    }

    public Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> getVertices() {
        Iterator vertices = this.getGraph().vertices(new Object[0]);
        return this.wrapVertices(vertices);
    }

    public AtlasVertex<AtlasJanusVertex, AtlasJanusEdge> addVertex() {
        JanusGraphVertex result = this.getGraph().addVertex(new Object[0]);
        return GraphDbObjectFactory.createVertex(this, (Vertex)result);
    }

    public AtlasIndexQueryParameter indexQueryParameter(String parameterName, String parameterValue) {
        return new AtlasJanusIndexQueryParameter(parameterName, parameterValue);
    }

    public AtlasGraphIndexClient getGraphIndexClient() throws AtlasException {
        try {
            this.initApplicationProperties();
            return new AtlasJanusGraphIndexClient(APPLICATION_PROPERTIES);
        }
        catch (Exception e) {
            LOG.error("Error encountered in creating Graph Index Client.", (Throwable)e);
            throw new AtlasException((Throwable)e);
        }
    }

    public void commit() {
        this.getGraph().tx().commit();
    }

    public void rollback() {
        this.getGraph().tx().rollback();
    }

    public AtlasIndexQuery<AtlasJanusVertex, AtlasJanusEdge> indexQuery(String indexName, String graphQuery) {
        return this.indexQuery(indexName, graphQuery, 0, null);
    }

    public AtlasIndexQuery<AtlasJanusVertex, AtlasJanusEdge> indexQuery(String indexName, String graphQuery, int offset) {
        return this.indexQuery(indexName, graphQuery, offset, null);
    }

    public AtlasIndexQuery<AtlasJanusVertex, AtlasJanusEdge> indexQuery(GraphIndexQueryParameters indexQueryParameters) {
        return this.indexQuery(indexQueryParameters.getIndexName(), indexQueryParameters.getGraphQueryString(), indexQueryParameters.getOffset(), indexQueryParameters.getIndexQueryParameters());
    }

    private AtlasIndexQuery<AtlasJanusVertex, AtlasJanusEdge> indexQuery(String indexName, String graphQuery, int offset, List<AtlasIndexQueryParameter> indexQueryParameterList) {
        String prefix = this.getIndexQueryPrefix();
        JanusGraphIndexQuery query = this.getGraph().indexQuery(indexName, graphQuery).setElementIdentifier(prefix).offset(offset);
        if (indexQueryParameterList != null && indexQueryParameterList.size() > 0) {
            for (AtlasIndexQueryParameter indexQueryParameter : indexQueryParameterList) {
                query = query.addParameter(new Parameter(indexQueryParameter.getParameterName(), (Object)indexQueryParameter.getParameterValue()));
            }
        }
        return new AtlasJanusIndexQuery(this, query);
    }

    public AtlasGraphManagement getManagementSystem() {
        return new AtlasJanusGraphManagement(this, this.getGraph().openManagement());
    }

    public Set getOpenTransactions() {
        return this.janusGraph.getOpenTransactions();
    }

    public void shutdown() {
        this.getGraph().close();
    }

    public Set<String> getEdgeIndexKeys() {
        return this.getIndexKeys(Edge.class);
    }

    public Set<String> getVertexIndexKeys() {
        return this.getIndexKeys(Vertex.class);
    }

    public AtlasVertex<AtlasJanusVertex, AtlasJanusEdge> getVertex(String vertexId) {
        Iterator it = this.getGraph().vertices(new Object[]{vertexId});
        Vertex vertex = (Vertex)AtlasJanusGraph.getSingleElement(it, vertexId);
        return GraphDbObjectFactory.createVertex(this, vertex);
    }

    public Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> getVertices(String key, Object value) {
        AtlasGraphQuery<AtlasJanusVertex, AtlasJanusEdge> query = this.query();
        query.has(key, value);
        return query.vertices();
    }

    public GremlinVersion getSupportedGremlinVersion() {
        return GremlinVersion.THREE;
    }

    public void clear() {
        JanusGraph graph = this.getGraph();
        if (graph.isOpen()) {
            graph.close();
        }
        try {
            JanusGraphFactory.drop((JanusGraph)graph);
        }
        catch (BackendException backendException) {
            // empty catch block
        }
    }

    public JanusGraph getGraph() {
        return this.janusGraph;
    }

    public void exportToGson(OutputStream os) throws IOException {
        GraphSONMapper mapper = ((GraphSONIo)this.getGraph().io(IoCore.graphson())).mapper().create();
        GraphSONWriter.Builder builder = GraphSONWriter.build();
        builder.mapper((Mapper)mapper);
        GraphSONWriter writer = builder.create();
        writer.writeGraph(os, (Graph)this.getGraph());
    }

    public GremlinGroovyScriptEngine getGremlinScriptEngine() {
        return this.scriptEngine.get();
    }

    public void releaseGremlinScriptEngine(ScriptEngine scriptEngine) {
        if (scriptEngine instanceof GremlinGroovyScriptEngine) {
            try {
                ((GremlinGroovyScriptEngine)scriptEngine).reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object executeGremlinScript(String query, boolean isPath) throws AtlasBaseException {
        Object result = this.executeGremlinScript(query);
        return this.convertGremlinValue(result);
    }

    public Object executeGremlinScript(ScriptEngine scriptEngine, Map<? extends String, ? extends Object> userBindings, String query, boolean isPath) throws ScriptException {
        Bindings bindings = scriptEngine.createBindings();
        bindings.putAll(userBindings);
        bindings.put("g", (Object)this.getGraph().traversal());
        Object result = scriptEngine.eval(query, bindings);
        return this.convertGremlinValue(result);
    }

    public GroovyExpression generatePersisentToLogicalConversionExpression(GroovyExpression expr, AtlasType type) {
        return expr;
    }

    public boolean isPropertyValueConversionNeeded(AtlasType type) {
        return false;
    }

    public boolean requiresInitialIndexedPredicate() {
        return false;
    }

    public GroovyExpression getInitialIndexedPredicate(GroovyExpression parent) {
        return parent;
    }

    public GroovyExpression addOutputTransformationPredicate(GroovyExpression expr, boolean isSelect, boolean isPath) {
        return expr;
    }

    public boolean isMultiProperty(String propertyName) {
        return this.multiProperties.contains(propertyName);
    }

    public Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> wrapVertices(Iterable<? extends Vertex> it) {
        return Iterables.transform(it, input -> GraphDbObjectFactory.createVertex(this, input));
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> wrapEdges(Iterator<? extends Edge> it) {
        IteratorToIterableAdapter iterable = new IteratorToIterableAdapter(it);
        return this.wrapEdges((Iterable<? extends Edge>)iterable);
    }

    public Iterable<AtlasEdge<AtlasJanusVertex, AtlasJanusEdge>> wrapEdges(Iterable<? extends Edge> it) {
        return Iterables.transform(it, input -> GraphDbObjectFactory.createEdge(this, input));
    }

    public void addMultiProperties(Set<String> names) {
        this.multiProperties.addAll(names);
    }

    String getIndexFieldName(AtlasPropertyKey propertyKey, JanusGraphIndex graphIndex, Parameter ... parameters) {
        PropertyKey janusKey = AtlasJanusObjectFactory.createPropertyKey(propertyKey);
        if (parameters == null) {
            parameters = EMPTY_PARAMETER_ARRAY;
        }
        return this.janusGraph.getIndexSerializer().getDefaultFieldName(janusKey, parameters, graphIndex.getBackingIndex());
    }

    private String getIndexQueryPrefix() {
        this.initApplicationProperties();
        String ret = APPLICATION_PROPERTIES == null ? "$v$" : APPLICATION_PROPERTIES.getString("atlas.graph.index.search.vertex.prefix", "$v$");
        return ret;
    }

    private Iterable<AtlasVertex<AtlasJanusVertex, AtlasJanusEdge>> wrapVertices(Iterator<? extends Vertex> it) {
        IteratorToIterableAdapter iterable = new IteratorToIterableAdapter(it);
        return this.wrapVertices((Iterable<? extends Vertex>)iterable);
    }

    private static <T> T getSingleElement(Iterator<T> it, String id) {
        if (!it.hasNext()) {
            return null;
        }
        T element = it.next();
        if (it.hasNext()) {
            throw new RuntimeException("Multiple items were found with the id " + id);
        }
        return element;
    }

    private Object convertGremlinValue(Object rawValue) {
        if (rawValue instanceof Vertex) {
            return GraphDbObjectFactory.createVertex(this, (Vertex)rawValue);
        }
        if (rawValue instanceof Edge) {
            return GraphDbObjectFactory.createEdge(this, (Edge)rawValue);
        }
        if (rawValue instanceof Map) {
            Map rowValue = (Map)rawValue;
            return Maps.transformValues((Map)rowValue, (Function)this.GREMLIN_VALUE_CONVERSION_FUNCTION);
        }
        if (rawValue instanceof ImmutablePath) {
            ImmutablePath path = (ImmutablePath)rawValue;
            return this.convertGremlinValue(path.objects());
        }
        if (rawValue instanceof List) {
            return Lists.transform((List)((List)rawValue), (Function)this.GREMLIN_VALUE_CONVERSION_FUNCTION);
        }
        if (rawValue instanceof Collection) {
            throw new UnsupportedOperationException("Unhandled collection type: " + rawValue.getClass());
        }
        return rawValue;
    }

    private Set<String> getIndexKeys(Class<? extends Element> janusGraphElementClass) {
        JanusGraphManagement mgmt = this.getGraph().openManagement();
        Iterable indices = mgmt.getGraphIndexes(janusGraphElementClass);
        HashSet<String> result = new HashSet<String>();
        for (JanusGraphIndex index : indices) {
            result.add(index.name());
        }
        mgmt.commit();
        return result;
    }

    private Object executeGremlinScript(String gremlinQuery) throws AtlasBaseException {
        GremlinGroovyScriptEngine scriptEngine = this.getGremlinScriptEngine();
        try {
            Object result;
            Bindings bindings = scriptEngine.createBindings();
            bindings.put("graph", (Object)this.getGraph());
            bindings.put("g", (Object)this.getGraph().traversal());
            Object object = result = scriptEngine.eval(gremlinQuery, bindings);
            return object;
        }
        catch (ScriptException e) {
            throw new AtlasBaseException(AtlasErrorCode.GREMLIN_SCRIPT_EXECUTION_FAILED, (Throwable)e, new String[]{gremlinQuery});
        }
        finally {
            this.releaseGremlinScriptEngine((ScriptEngine)scriptEngine);
        }
    }

    private void initApplicationProperties() {
        if (APPLICATION_PROPERTIES == null) {
            try {
                APPLICATION_PROPERTIES = ApplicationProperties.get();
            }
            catch (AtlasException atlasException) {
                // empty catch block
            }
        }
    }

    private Edge getFirstActiveEdge(GraphTraversal gt) {
        while (gt.hasNext()) {
            Edge gremlinEdge = (Edge)gt.next();
            if (gremlinEdge == null || !gremlinEdge.property(Constants.STATE_PROPERTY_KEY).isPresent() || !gremlinEdge.property(Constants.STATE_PROPERTY_KEY).value().equals(AtlasEntity.Status.ACTIVE.toString())) continue;
            return gremlinEdge;
        }
        return null;
    }

    private final class ConvertGremlinValueFunction
    implements Function<Object, Object> {
        private ConvertGremlinValueFunction() {
        }

        public Object apply(Object input) {
            return AtlasJanusGraph.this.convertGremlinValue(input);
        }
    }
}

