/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.atlas.SortOrder;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.util.SearchPredicateUtil;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySearchProcessor
extends SearchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(EntitySearchProcessor.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"EntitySearchProcessor");
    private final AtlasIndexQuery indexQuery;
    private final AtlasGraphQuery graphQuery;
    private Predicate graphQueryPredicate;
    private Predicate filterGraphQueryPredicate;

    public EntitySearchProcessor(SearchContext context) {
        super(context);
        Set<AtlasEntityType> entityTypes = context.getEntityTypes();
        SearchParameters.FilterCriteria filterCriteria = context.getSearchParameters().getEntityFilters();
        HashSet<String> indexAttributes = new HashSet<String>();
        HashSet<String> graphAttributes = new HashSet<String>();
        HashSet<String> allAttributes = new HashSet<String>();
        Set<String> typeAndSubTypes = context.getEntityTypeNames();
        String typeAndSubTypesQryStr = context.getEntityTypesQryStr();
        String sortBy = context.getSearchParameters().getSortBy();
        SortOrder sortOrder = context.getSearchParameters().getSortOrder();
        Set<AtlasClassificationType> classificationTypes = context.getClassificationTypes();
        Set<String> classificationTypeAndSubTypes = context.getClassificationTypeNames();
        boolean filterClassification = CollectionUtils.isNotEmpty(classificationTypes) ? !context.needClassificationProcessor() : false;
        Predicate traitPredicate = this.buildTraitPredict(classificationTypes);
        Predicate activePredicate = SearchPredicateUtil.getEQPredicateGenerator().generatePredicate(Constants.STATE_PROPERTY_KEY, "ACTIVE", String.class);
        Predicate typeNamePredicate = !this.isEntityRootType() ? SearchPredicateUtil.getINPredicateGenerator().generatePredicate("__typeName", typeAndSubTypes, String.class) : SearchPredicateUtil.generateIsEntityVertexPredicate(context.getTypeRegistry());
        this.processSearchAttributes(entityTypes, filterCriteria, indexAttributes, graphAttributes, allAttributes);
        boolean typeSearchByIndex = !filterClassification && typeAndSubTypesQryStr.length() <= MAX_QUERY_STR_LENGTH_TYPES;
        boolean attrSearchByIndex = !filterClassification && CollectionUtils.isNotEmpty(indexAttributes) && this.canApplyIndexFilter(entityTypes, filterCriteria, false);
        StringBuilder indexQuery = new StringBuilder();
        this.inMemoryPredicate = typeNamePredicate;
        if (typeSearchByIndex) {
            this.graphIndexQueryBuilder.addTypeAndSubTypesQueryFilter(indexQuery, typeAndSubTypesQryStr);
        }
        if (attrSearchByIndex) {
            this.constructFilterQuery(indexQuery, entityTypes, filterCriteria, indexAttributes);
            Predicate attributePredicate = this.constructInMemoryPredicate(entityTypes, filterCriteria, indexAttributes);
            if (attributePredicate != null) {
                this.inMemoryPredicate = PredicateUtils.andPredicate((Predicate)this.inMemoryPredicate, (Predicate)attributePredicate);
            }
        } else {
            graphAttributes.addAll(indexAttributes);
        }
        if (indexQuery.length() > 0) {
            this.graphIndexQueryBuilder.addActiveStateQueryFilter(indexQuery);
            String indexQueryString = STRAY_AND_PATTERN.matcher(indexQuery).replaceAll(")");
            indexQueryString = STRAY_OR_PATTERN.matcher(indexQueryString).replaceAll(")");
            indexQueryString = STRAY_ELIPSIS_PATTERN.matcher(indexQueryString).replaceAll("");
            this.indexQuery = context.getGraph().indexQuery("vertex_index", indexQueryString);
        } else {
            this.indexQuery = null;
        }
        if (CollectionUtils.isNotEmpty(graphAttributes) || !typeSearchByIndex) {
            AtlasEntityType entityType;
            AtlasStructType.AtlasAttribute sortByAttribute;
            AtlasGraphQuery query = context.getGraph().query();
            if (!typeSearchByIndex && !this.isEntityRootType()) {
                query.in("__typeName", typeAndSubTypes);
            }
            if (filterClassification) {
                AtlasClassificationType classificationType = classificationTypes.iterator().next();
                LinkedList<AtlasGraphQuery> orConditions = new LinkedList<AtlasGraphQuery>();
                if (classificationType == SearchContext.MATCH_ALL_WILDCARD_CLASSIFICATION || classificationType == SearchContext.MATCH_ALL_CLASSIFIED || classificationType == SearchContext.MATCH_ALL_CLASSIFICATION_TYPES) {
                    orConditions.add(query.createChildQuery().has(Constants.TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, null));
                    orConditions.add(query.createChildQuery().has(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, null));
                } else if (classificationType == SearchContext.MATCH_ALL_NOT_CLASSIFIED) {
                    orConditions.add(query.createChildQuery().has(Constants.TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, null).has(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, null));
                } else {
                    orConditions.add(query.createChildQuery().in(Constants.TRAIT_NAMES_PROPERTY_KEY, classificationTypeAndSubTypes));
                    orConditions.add(query.createChildQuery().in(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, classificationTypeAndSubTypes));
                }
                query.or(orConditions);
                if (this.isEntityRootType()) {
                    this.inMemoryPredicate = typeNamePredicate;
                }
                this.graphQueryPredicate = this.graphQueryPredicate != null ? PredicateUtils.andPredicate((Predicate)this.graphQueryPredicate, (Predicate)traitPredicate) : traitPredicate;
            }
            this.graphQuery = this.toGraphFilterQuery(entityTypes, filterCriteria, graphAttributes, query);
            Predicate attributePredicate = this.constructInMemoryPredicate(entityTypes, filterCriteria, graphAttributes);
            if (attributePredicate != null) {
                this.graphQueryPredicate = this.graphQueryPredicate != null ? PredicateUtils.andPredicate((Predicate)this.graphQueryPredicate, (Predicate)attributePredicate) : attributePredicate;
            }
            if (context.getSearchParameters().getExcludeDeletedEntities() && this.indexQuery == null) {
                this.graphQuery.has(Constants.STATE_PROPERTY_KEY, (Object)"ACTIVE");
                this.graphQueryPredicate = this.graphQueryPredicate != null ? PredicateUtils.andPredicate((Predicate)this.graphQueryPredicate, (Predicate)activePredicate) : activePredicate;
            }
            if (sortBy != null && !sortBy.isEmpty() && (sortByAttribute = (entityType = context.getEntityTypes().iterator().next()).getAttribute(sortBy)) != null) {
                AtlasGraphQuery.SortOrder qrySortOrder = sortOrder == SortOrder.ASCENDING ? AtlasGraphQuery.SortOrder.ASC : AtlasGraphQuery.SortOrder.DESC;
                this.graphQuery.orderBy(sortByAttribute.getVertexPropertyName(), qrySortOrder);
            }
        } else {
            this.graphQuery = null;
            this.graphQueryPredicate = null;
        }
        this.filterGraphQueryPredicate = typeNamePredicate;
        Predicate attributesPredicate = this.constructInMemoryPredicate(entityTypes, filterCriteria, allAttributes);
        if (attributesPredicate != null) {
            Predicate predicate = this.filterGraphQueryPredicate = this.filterGraphQueryPredicate == null ? attributesPredicate : PredicateUtils.andPredicate((Predicate)this.filterGraphQueryPredicate, (Predicate)attributesPredicate);
        }
        if (filterClassification) {
            Predicate predicate = this.filterGraphQueryPredicate = this.filterGraphQueryPredicate == null ? traitPredicate : PredicateUtils.andPredicate((Predicate)this.filterGraphQueryPredicate, (Predicate)traitPredicate);
        }
        if (context.getSearchParameters().getExcludeDeletedEntities()) {
            this.filterGraphQueryPredicate = this.filterGraphQueryPredicate == null ? activePredicate : PredicateUtils.andPredicate((Predicate)this.filterGraphQueryPredicate, (Predicate)activePredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AtlasVertex> execute() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntitySearchProcessor.execute({})", (Object)this.context);
        }
        ArrayList<AtlasVertex> ret = new ArrayList<AtlasVertex>();
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntitySearchProcessor.execute(" + this.context + ")"));
        }
        try {
            int startIdx;
            int limit = this.context.getSearchParameters().getLimit();
            Integer marker = this.context.getMarker();
            int n = startIdx = marker != null ? marker.intValue() : this.context.getSearchParameters().getOffset();
            int qryOffset = marker != null ? marker : (this.nextProcessor != null || this.graphQuery != null && this.indexQuery != null ? 0 : startIdx);
            int resultIdx = qryOffset;
            LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap = new LinkedHashMap<Integer, AtlasVertex>();
            while (ret.size() < limit) {
                offsetEntityVertexMap.clear();
                if (this.context.terminateSearch()) {
                    LOG.warn("query terminated: {}", (Object)this.context.getSearchParameters());
                    break;
                }
                if (this.indexQuery != null) {
                    Iterator<AtlasIndexQuery.Result> idxQueryResult = EntitySearchProcessor.executeIndexQuery(this.context, this.indexQuery, qryOffset, limit);
                    offsetEntityVertexMap = this.getVerticesFromIndexQueryResult(idxQueryResult, offsetEntityVertexMap, qryOffset);
                } else {
                    Iterator<AtlasVertex> queryResult = this.graphQuery.vertices(qryOffset, limit).iterator();
                    offsetEntityVertexMap = this.getVertices(queryResult, offsetEntityVertexMap, qryOffset);
                }
                boolean isLastResultPage = offsetEntityVertexMap.size() < limit;
                offsetEntityVertexMap = super.filter(offsetEntityVertexMap, this.inMemoryPredicate);
                if (this.graphQueryPredicate != null) {
                    offsetEntityVertexMap = super.filter(offsetEntityVertexMap, this.graphQueryPredicate);
                }
                offsetEntityVertexMap = super.filter(offsetEntityVertexMap);
                resultIdx = this.collectResultVertices(ret, startIdx, limit, resultIdx, offsetEntityVertexMap, marker);
                if (isLastResultPage) {
                    resultIdx = -2;
                    break;
                }
                qryOffset += limit;
            }
            if (marker != null) {
                this.nextOffset = resultIdx + 1;
            }
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntitySearchProcessor.execute({}): ret.size()={}", (Object)this.context, (Object)ret.size());
        }
        return ret;
    }

    @Override
    public LinkedHashMap<Integer, AtlasVertex> filter(LinkedHashMap<Integer, AtlasVertex> offsetEntityVertexMap) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntitySearchProcessor.filter({})", (Object)offsetEntityVertexMap.size());
        }
        if (this.filterGraphQueryPredicate != null) {
            LOG.debug("Filtering in-memory");
            offsetEntityVertexMap = super.filter(offsetEntityVertexMap, this.filterGraphQueryPredicate);
        }
        offsetEntityVertexMap = super.filter(offsetEntityVertexMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntitySearchProcessor.filter(): ret.size()={}", (Object)offsetEntityVertexMap.size());
        }
        return offsetEntityVertexMap;
    }

    @Override
    public long getResultCount() {
        if (this.indexQuery != null) {
            return this.indexQuery.vertexTotals();
        }
        if (this.graphQuery != null) {
            return StreamSupport.stream(this.graphQuery.vertexIds().spliterator(), false).count();
        }
        return -1L;
    }
}

