/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.List;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;

public class SingleColumnRelation
extends Relation {
    private final ColumnIdentifier.Raw entity;
    private final Term.Raw value;
    private final List<Term.Raw> inValues;
    public final boolean onToken;

    private SingleColumnRelation(ColumnIdentifier.Raw entity, Operator type, Term.Raw value, List<Term.Raw> inValues, boolean onToken) {
        this.entity = entity;
        this.relationType = type;
        this.value = value;
        this.inValues = inValues;
        this.onToken = onToken;
    }

    public SingleColumnRelation(ColumnIdentifier.Raw entity, Operator type, Term.Raw value) {
        this(entity, type, value, null, false);
    }

    public SingleColumnRelation(ColumnIdentifier.Raw entity, Operator type, Term.Raw value, boolean onToken) {
        this(entity, type, value, null, onToken);
    }

    public static SingleColumnRelation createInRelation(ColumnIdentifier.Raw entity, List<Term.Raw> inValues) {
        return new SingleColumnRelation(entity, Operator.IN, null, inValues, false);
    }

    public ColumnIdentifier.Raw getEntity() {
        return this.entity;
    }

    public Term.Raw getValue() {
        assert (this.relationType != Operator.IN || this.value == null || this.value instanceof AbstractMarker.INRaw);
        return this.value;
    }

    public List<Term.Raw> getInValues() {
        assert (this.relationType == Operator.IN);
        return this.inValues;
    }

    @Override
    public boolean isMultiColumn() {
        return false;
    }

    @Override
    public boolean isOnToken() {
        return this.onToken;
    }

    public SingleColumnRelation withNonStrictOperator() {
        switch (this.relationType) {
            case GT: {
                return new SingleColumnRelation(this.entity, Operator.GTE, this.value);
            }
            case LT: {
                return new SingleColumnRelation(this.entity, Operator.LTE, this.value);
            }
        }
        return this;
    }

    public String toString() {
        if (this.relationType == Operator.IN) {
            return String.format("%s IN %s", this.entity, this.inValues);
        }
        if (this.onToken) {
            return String.format("token(%s) %s %s", new Object[]{this.entity, this.relationType, this.value});
        }
        return String.format("%s %s %s", new Object[]{this.entity, this.relationType, this.value});
    }
}

