/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.AbstractRangeCommand;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;

public class PagedRangeCommand
extends AbstractRangeCommand {
    public static final IVersionedSerializer<PagedRangeCommand> serializer = new Serializer();
    public final Composite start;
    public final Composite stop;
    public final int limit;
    private final boolean countCQL3Rows;

    public PagedRangeCommand(String keyspace, String columnFamily, long timestamp, AbstractBounds<RowPosition> keyRange, SliceQueryFilter predicate, Composite start, Composite stop, List<IndexExpression> rowFilter, int limit, boolean countCQL3Rows) {
        super(keyspace, columnFamily, timestamp, keyRange, predicate, rowFilter);
        this.start = start;
        this.stop = stop;
        this.limit = limit;
        this.countCQL3Rows = countCQL3Rows;
    }

    public MessageOut<PagedRangeCommand> createMessage() {
        return new MessageOut<PagedRangeCommand>(MessagingService.Verb.PAGED_RANGE, this, serializer);
    }

    @Override
    public AbstractRangeCommand forSubRange(AbstractBounds<RowPosition> subRange) {
        Composite newStart = ((RowPosition)subRange.left).equals(this.keyRange.left) ? this.start : ((SliceQueryFilter)this.predicate).start();
        Composite newStop = ((RowPosition)subRange.right).equals(this.keyRange.right) ? this.stop : ((SliceQueryFilter)this.predicate).finish();
        return new PagedRangeCommand(this.keyspace, this.columnFamily, this.timestamp, subRange, ((SliceQueryFilter)this.predicate).cloneShallow(), newStart, newStop, this.rowFilter, this.limit, this.countCQL3Rows);
    }

    @Override
    public AbstractRangeCommand withUpdatedLimit(int newLimit) {
        return new PagedRangeCommand(this.keyspace, this.columnFamily, this.timestamp, this.keyRange, ((SliceQueryFilter)this.predicate).cloneShallow(), this.start, this.stop, this.rowFilter, newLimit, this.countCQL3Rows);
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public boolean countCQL3Rows() {
        return this.countCQL3Rows;
    }

    @Override
    public List<Row> executeLocally() {
        ColumnFamilyStore cfs = Keyspace.open(this.keyspace).getColumnFamilyStore(this.columnFamily);
        ExtendedFilter exFilter = cfs.makeExtendedFilter(this.keyRange, (SliceQueryFilter)this.predicate, this.start, this.stop, this.rowFilter, this.limit, this.countCQL3Rows(), this.timestamp);
        if (cfs.indexManager.hasIndexFor(this.rowFilter)) {
            return cfs.search(exFilter);
        }
        return cfs.getRangeSlice(exFilter);
    }

    public String toString() {
        return String.format("PagedRange(%s, %s, %d, %s, %s, %s, %s, %s, %d)", this.keyspace, this.columnFamily, this.timestamp, this.keyRange, this.predicate, this.start, this.stop, this.rowFilter, this.limit);
    }

    private static class Serializer
    implements IVersionedSerializer<PagedRangeCommand> {
        private Serializer() {
        }

        @Override
        public void serialize(PagedRangeCommand cmd, DataOutputPlus out, int version) throws IOException {
            out.writeUTF(cmd.keyspace);
            out.writeUTF(cmd.columnFamily);
            out.writeLong(cmd.timestamp);
            AbstractBounds.serializer.serialize(cmd.keyRange, out, version);
            CFMetaData metadata = Schema.instance.getCFMetaData(cmd.keyspace, cmd.columnFamily);
            SliceQueryFilter filter = (SliceQueryFilter)cmd.predicate;
            metadata.comparator.sliceQueryFilterSerializer().serialize(filter, out, version);
            metadata.comparator.serializer().serialize(cmd.start, out);
            metadata.comparator.serializer().serialize(cmd.stop, out);
            out.writeInt(cmd.rowFilter.size());
            for (IndexExpression expr : cmd.rowFilter) {
                expr.writeTo(out);
            }
            out.writeInt(cmd.limit);
            if (version >= 8) {
                out.writeBoolean(cmd.countCQL3Rows);
            }
        }

        @Override
        public PagedRangeCommand deserialize(DataInput in, int version) throws IOException {
            String keyspace = in.readUTF();
            String columnFamily = in.readUTF();
            long timestamp = in.readLong();
            AbstractBounds<RowPosition> keyRange = ((AbstractBounds)AbstractBounds.serializer.deserialize(in, version)).toRowBounds();
            CFMetaData metadata = Schema.instance.getCFMetaData(keyspace, columnFamily);
            if (metadata == null) {
                String message = String.format("Got paged range command for nonexistent table %s.%s.  If the table was just created, this is likely due to the schema not being fully propagated.  Please wait for schema agreement on table creation.", keyspace, columnFamily);
                throw new UnknownColumnFamilyException(message, null);
            }
            SliceQueryFilter predicate = metadata.comparator.sliceQueryFilterSerializer().deserialize(in, version);
            Composite start = (Composite)metadata.comparator.serializer().deserialize(in);
            Composite stop = (Composite)metadata.comparator.serializer().deserialize(in);
            int filterCount = in.readInt();
            ArrayList<IndexExpression> rowFilter = new ArrayList<IndexExpression>(filterCount);
            for (int i = 0; i < filterCount; ++i) {
                rowFilter.add(IndexExpression.readFrom(in));
            }
            int limit = in.readInt();
            boolean countCQL3Rows = version >= 8 ? in.readBoolean() : predicate.compositesToGroup >= 0 || predicate.count != 1;
            return new PagedRangeCommand(keyspace, columnFamily, timestamp, keyRange, predicate, start, stop, rowFilter, limit, countCQL3Rows);
        }

        @Override
        public long serializedSize(PagedRangeCommand cmd, int version) {
            long size = 0L;
            size += (long)TypeSizes.NATIVE.sizeof(cmd.keyspace);
            size += (long)TypeSizes.NATIVE.sizeof(cmd.columnFamily);
            size += (long)TypeSizes.NATIVE.sizeof(cmd.timestamp);
            size += AbstractBounds.serializer.serializedSize(cmd.keyRange, version);
            CFMetaData metadata = Schema.instance.getCFMetaData(cmd.keyspace, cmd.columnFamily);
            size += metadata.comparator.sliceQueryFilterSerializer().serializedSize((SliceQueryFilter)cmd.predicate, version);
            size += metadata.comparator.serializer().serializedSize(cmd.start, TypeSizes.NATIVE);
            size += metadata.comparator.serializer().serializedSize(cmd.stop, TypeSizes.NATIVE);
            size += (long)TypeSizes.NATIVE.sizeof(cmd.rowFilter.size());
            for (IndexExpression expr : cmd.rowFilter) {
                size += (long)TypeSizes.NATIVE.sizeofWithShortLength(expr.column);
                size += (long)TypeSizes.NATIVE.sizeof(expr.operator.ordinal());
                size += (long)TypeSizes.NATIVE.sizeofWithShortLength(expr.value);
            }
            size += (long)TypeSizes.NATIVE.sizeof(cmd.limit);
            if (version >= 8) {
                size += (long)TypeSizes.NATIVE.sizeof(cmd.countCQL3Rows);
            }
            return size;
        }
    }
}

